/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.activities.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.papyrus.sysml.activities.provider.ContinuousItemProvider;
import org.eclipse.papyrus.sysml.activities.provider.ControlOperatorItemProvider;
import org.eclipse.papyrus.sysml.activities.provider.DiscreteItemProvider;
import org.eclipse.papyrus.sysml.activities.provider.NoBufferItemProvider;
import org.eclipse.papyrus.sysml.activities.provider.OptionalItemProvider;
import org.eclipse.papyrus.sysml.activities.provider.OverwriteItemProvider;
import org.eclipse.papyrus.sysml.activities.provider.ProbabilityItemProvider;
import org.eclipse.papyrus.sysml.activities.provider.RateItemProvider;
import org.eclipse.papyrus.sysml.activities.util.ActivitiesAdapterFactory;
import org.eclipse.papyrus.sysml.edit.provider.IComposableAdapterFactory;
import org.eclipse.papyrus.sysml.edit.provider.IRootAdapterFactory;

public class ActivitiesItemProviderAdapterFactory
extends ActivitiesAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IComposableAdapterFactory,
IDisposable {
    protected IRootAdapterFactory rootAdapterFactory;
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected Collection<Object> supportedTypes = new ArrayList<Object>();
    protected OptionalItemProvider optionalItemProvider;
    protected RateItemProvider rateItemProvider;
    protected ProbabilityItemProvider probabilityItemProvider;
    protected ContinuousItemProvider continuousItemProvider;
    protected DiscreteItemProvider discreteItemProvider;
    protected ControlOperatorItemProvider controlOperatorItemProvider;
    protected NoBufferItemProvider noBufferItemProvider;
    protected OverwriteItemProvider overwriteItemProvider;

    public IRootAdapterFactory getIRootAdapterFactory() {
        return this.rootAdapterFactory;
    }

    public void setRootAdapterFactory(IRootAdapterFactory root) {
        if (!(root instanceof IRootAdapterFactory)) {
            throw new RuntimeException(root + " do not implement IRootAdapterFactory");
        }
        this.rootAdapterFactory = root;
    }

    public ActivitiesItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    public Adapter createOptionalAdapter() {
        if (this.optionalItemProvider == null) {
            this.optionalItemProvider = new OptionalItemProvider((AdapterFactory)this);
        }
        return this.optionalItemProvider;
    }

    public Adapter createRateAdapter() {
        if (this.rateItemProvider == null) {
            this.rateItemProvider = new RateItemProvider((AdapterFactory)this);
        }
        return this.rateItemProvider;
    }

    public Adapter createProbabilityAdapter() {
        if (this.probabilityItemProvider == null) {
            this.probabilityItemProvider = new ProbabilityItemProvider((AdapterFactory)this);
        }
        return this.probabilityItemProvider;
    }

    public Adapter createContinuousAdapter() {
        if (this.continuousItemProvider == null) {
            this.continuousItemProvider = new ContinuousItemProvider((AdapterFactory)this);
        }
        return this.continuousItemProvider;
    }

    public Adapter createDiscreteAdapter() {
        if (this.discreteItemProvider == null) {
            this.discreteItemProvider = new DiscreteItemProvider((AdapterFactory)this);
        }
        return this.discreteItemProvider;
    }

    public Adapter createControlOperatorAdapter() {
        if (this.controlOperatorItemProvider == null) {
            this.controlOperatorItemProvider = new ControlOperatorItemProvider((AdapterFactory)this);
        }
        return this.controlOperatorItemProvider;
    }

    public Adapter createNoBufferAdapter() {
        if (this.noBufferItemProvider == null) {
            this.noBufferItemProvider = new NoBufferItemProvider((AdapterFactory)this);
        }
        return this.noBufferItemProvider;
    }

    public Adapter createOverwriteAdapter() {
        if (this.overwriteItemProvider == null) {
            this.overwriteItemProvider = new OverwriteItemProvider((AdapterFactory)this);
        }
        return this.overwriteItemProvider;
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        if (this.optionalItemProvider != null) {
            this.optionalItemProvider.dispose();
        }
        if (this.rateItemProvider != null) {
            this.rateItemProvider.dispose();
        }
        if (this.probabilityItemProvider != null) {
            this.probabilityItemProvider.dispose();
        }
        if (this.continuousItemProvider != null) {
            this.continuousItemProvider.dispose();
        }
        if (this.discreteItemProvider != null) {
            this.discreteItemProvider.dispose();
        }
        if (this.controlOperatorItemProvider != null) {
            this.controlOperatorItemProvider.dispose();
        }
        if (this.noBufferItemProvider != null) {
            this.noBufferItemProvider.dispose();
        }
        if (this.overwriteItemProvider != null) {
            this.overwriteItemProvider.dispose();
        }
    }
}

