/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.activities.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.papyrus.sysml.activities.Discrete;
import org.eclipse.papyrus.sysml.activities.provider.RateItemProvider;
import org.eclipse.papyrus.sysml.edit.provider.IComposableAdapterFactory;
import org.eclipse.papyrus.sysml.edit.provider.IVisibilityOverlayImage;
import org.eclipse.papyrus.sysml.util.SysmlResource;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.edit.UMLEditPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiscreteItemProvider
extends RateItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
IVisibilityOverlayImage {
    private static Pattern DISCRETE_PREFIX_PATTERN = Pattern.compile("(discrete, |<<discrete>>|, discrete)");
    private static Pattern PARAMETER_PREFIX_PATTERN = Pattern.compile("Parameter");
    private static Pattern ACTIVITY_EDGE_PREFIX_PATTERN = Pattern.compile("Activity Edge");

    public DiscreteItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (object instanceof Discrete && this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
        }
        if (object instanceof Parameter) {
            Parameter element = (Parameter)object;
            ArrayList<IItemPropertyDescriptor> itemPropertyDescriptorsForparameter = new ArrayList<IItemPropertyDescriptor>();
            ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.PARAMETER);
            List propertyDescriptors = ite.getPropertyDescriptors((Object)this);
            itemPropertyDescriptorsForparameter.addAll(propertyDescriptors);
            Stereotype ste = element.getAppliedStereotype(SysmlResource.DISCRETE_ID);
            if (ste != null) {
                EObject eObject = element.getStereotypeApplication(ste);
            }
            return itemPropertyDescriptorsForparameter;
        }
        if (object instanceof ActivityEdge) {
            ActivityEdge element = (ActivityEdge)object;
            ArrayList<IItemPropertyDescriptor> itemPropertyDescriptorsForactivityEdge = new ArrayList<IItemPropertyDescriptor>();
            ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.ACTIVITY_EDGE);
            List propertyDescriptors = ite.getPropertyDescriptors((Object)this);
            itemPropertyDescriptorsForactivityEdge.addAll(propertyDescriptors);
            Stereotype ste = element.getAppliedStereotype(SysmlResource.DISCRETE_ID);
            if (ste != null) {
                EObject eObject = element.getStereotypeApplication(ste);
            }
            return itemPropertyDescriptorsForactivityEdge;
        }
        return this.itemPropertyDescriptors;
    }

    @Override
    public Object getImage(Object object) {
        Object composedImage = this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Discrete"));
        if (object instanceof NamedElement) {
            ComposedImage aux = new ComposedImage(Collections.singletonList(composedImage));
            return this.composeVisibilityImage(object, aux);
        }
        return composedImage;
    }

    @Override
    public String getText(Object object) {
        Stereotype ste;
        Discrete discrete_ = null;
        if (object instanceof Parameter && (ste = ((Parameter)object).getAppliedStereotype(SysmlResource.DISCRETE_ID)) != null) {
            IItemLabelProvider ite = (IItemLabelProvider)((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.PARAMETER);
            String result = ite.getText(object);
            result = DISCRETE_PREFIX_PATTERN.matcher(result).replaceFirst("");
            return PARAMETER_PREFIX_PATTERN.matcher(result).replaceFirst("Discrete");
        }
        if (object instanceof ActivityEdge && (ste = ((ActivityEdge)object).getAppliedStereotype(SysmlResource.DISCRETE_ID)) != null) {
            IItemLabelProvider ite = (IItemLabelProvider)((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.ACTIVITY_EDGE);
            String result = ite.getText(object);
            result = DISCRETE_PREFIX_PATTERN.matcher(result).replaceFirst("");
            return ACTIVITY_EDGE_PREFIX_PATTERN.matcher(result).replaceFirst("Discrete");
        }
        discrete_ = (Discrete)object;
        return this.getString("_UI_Discrete_type");
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        if (((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory() != null) {
            if (notification.getFeatureID(Parameter.class) != -1) {
                ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.PARAMETER);
                ite.notifyChanged(notification);
                return;
            }
            if (notification.getFeatureID(ActivityEdge.class) != -1) {
                ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.ACTIVITY_EDGE);
                ite.notifyChanged(notification);
                return;
            }
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    @Override
    public ComposedImage composeVisibilityImage(Object object, ComposedImage composedImage) {
        NamedElement namedElement = (NamedElement)object;
        if (namedElement.isSetVisibility()) {
            composedImage.getImages().add(UMLEditPlugin.INSTANCE.getImage("full/ovr16/VisibilityKind_" + namedElement.getVisibility().getName()));
        }
        return composedImage;
    }

    @Override
    public Collection<?> getChildren(Object object) {
        Collection<?> result = super.getChildren(object);
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory() != null) {
                if (UMLPackage.Literals.PARAMETER.equals(eObject.eClass())) {
                    ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.PARAMETER);
                    result.addAll(ite.getChildren(object));
                    return result;
                }
                if (UMLPackage.Literals.ACTIVITY_EDGE.equals(eObject.eClass())) {
                    ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.ACTIVITY_EDGE);
                    result.addAll(ite.getChildren(object));
                    return result;
                }
            }
        }
        return result;
    }

    @Override
    public boolean hasChildren(Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory() != null) {
                if (UMLPackage.Literals.PARAMETER.equals(eObject.eClass())) {
                    ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.PARAMETER);
                    return super.hasChildren(object) || ite.hasChildren(object);
                }
                if (UMLPackage.Literals.ACTIVITY_EDGE.equals(eObject.eClass())) {
                    ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.ACTIVITY_EDGE);
                    return super.hasChildren(object) || ite.hasChildren(object);
                }
            }
        }
        return super.hasChildren(object);
    }
}

