/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.activities.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptorDecorator;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.papyrus.sysml.activities.ActivitiesPackage;
import org.eclipse.papyrus.sysml.activities.Optional;
import org.eclipse.papyrus.sysml.edit.provider.IComposableAdapterFactory;
import org.eclipse.papyrus.sysml.edit.provider.SysMLItemProviderAdapter;
import org.eclipse.papyrus.sysml.provider.SysmlEditPlugin;
import org.eclipse.papyrus.sysml.util.SysmlResource;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionalItemProvider
extends SysMLItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    private static Pattern OPTIONAL_PREFIX_PATTERN = Pattern.compile("(optional, |<<optional>>|, optional)");
    private static Pattern PARAMETER_PREFIX_PATTERN = Pattern.compile("Parameter");

    public OptionalItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (object instanceof Optional && this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addBase_ParameterPropertyDescriptor(object);
        }
        if (object instanceof Parameter) {
            Parameter element = (Parameter)object;
            ArrayList<IItemPropertyDescriptor> itemPropertyDescriptorsForparameter = new ArrayList<IItemPropertyDescriptor>();
            ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.PARAMETER);
            List propertyDescriptors = ite.getPropertyDescriptors((Object)this);
            itemPropertyDescriptorsForparameter.addAll(propertyDescriptors);
            Stereotype ste = element.getAppliedStereotype(SysmlResource.OPTIONAL_ID);
            if (ste != null) {
                EObject steApplication = element.getStereotypeApplication(ste);
                itemPropertyDescriptorsForparameter.add((IItemPropertyDescriptor)this.createBase_ParameterPropertyDescriptorForParameter(steApplication));
            }
            return itemPropertyDescriptorsForparameter;
        }
        return this.itemPropertyDescriptors;
    }

    protected void addBase_ParameterPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Optional_base_Parameter_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Optional_base_Parameter_feature", "_UI_Optional_type"), (EStructuralFeature)ActivitiesPackage.Literals.OPTIONAL__BASE_PARAMETER, true, false, true, null, null, null));
    }

    protected ItemPropertyDescriptorDecorator createBase_ParameterPropertyDescriptorForParameter(Object object) {
        return new ItemPropertyDescriptorDecorator(object, (IItemPropertyDescriptor)this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Optional_base_Parameter_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Optional_base_Parameter_feature", "_UI_Optional_type"), (EStructuralFeature)ActivitiesPackage.Literals.OPTIONAL__BASE_PARAMETER, true, false, true, null, null, null));
    }

    public Object getImage(Object object) {
        Object composedImage = this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Optional"));
        if (object instanceof NamedElement) {
            ComposedImage aux = new ComposedImage(Collections.singletonList(composedImage));
            return this.composeVisibilityImage(object, aux);
        }
        return composedImage;
    }

    public String getText(Object object) {
        Stereotype ste;
        Optional optional_ = null;
        if (object instanceof Parameter && (ste = ((Parameter)object).getAppliedStereotype(SysmlResource.OPTIONAL_ID)) != null) {
            IItemLabelProvider ite = (IItemLabelProvider)((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.PARAMETER);
            String result = ite.getText(object);
            result = OPTIONAL_PREFIX_PATTERN.matcher(result).replaceFirst("");
            return PARAMETER_PREFIX_PATTERN.matcher(result).replaceFirst("Optional");
        }
        optional_ = (Optional)object;
        return this.getString("_UI_Optional_type");
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        if (((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory() != null && notification.getFeatureID(Parameter.class) != -1) {
            ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.PARAMETER);
            ite.notifyChanged(notification);
            return;
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return SysmlEditPlugin.INSTANCE;
    }

    public Collection<?> getChildren(Object object) {
        Collection result = super.getChildren(object);
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory() != null && UMLPackage.Literals.PARAMETER.equals(eObject.eClass())) {
                ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.PARAMETER);
                result.addAll(ite.getChildren(object));
                return result;
            }
        }
        return result;
    }

    public boolean hasChildren(Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory() != null && UMLPackage.Literals.PARAMETER.equals(eObject.eClass())) {
                ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.PARAMETER);
                return super.hasChildren(object) || ite.hasChildren(object);
            }
        }
        return super.hasChildren(object);
    }
}

