/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.activities.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptorDecorator;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.papyrus.sysml.activities.ActivitiesPackage;
import org.eclipse.papyrus.sysml.activities.Rate;
import org.eclipse.papyrus.sysml.edit.provider.IComposableAdapterFactory;
import org.eclipse.papyrus.sysml.edit.provider.SysMLItemProviderAdapter;
import org.eclipse.papyrus.sysml.provider.SysmlEditPlugin;
import org.eclipse.papyrus.sysml.util.SysmlResource;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Parameter;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RateItemProvider
extends SysMLItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    private static Pattern RATE_PREFIX_PATTERN = Pattern.compile("(rate, |<<rate>>|, rate)");
    private static Pattern PARAMETER_PREFIX_PATTERN = Pattern.compile("Parameter");
    private static Pattern ACTIVITY_EDGE_PREFIX_PATTERN = Pattern.compile("Activity Edge");

    public RateItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (object instanceof Rate && this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addBase_ParameterPropertyDescriptor(object);
            this.addBase_ActivityEdgePropertyDescriptor(object);
            this.addRatePropertyDescriptor(object);
        }
        if (object instanceof Parameter) {
            Parameter element = (Parameter)object;
            ArrayList<IItemPropertyDescriptor> itemPropertyDescriptorsForparameter = new ArrayList<IItemPropertyDescriptor>();
            ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.PARAMETER);
            List propertyDescriptors = ite.getPropertyDescriptors((Object)this);
            itemPropertyDescriptorsForparameter.addAll(propertyDescriptors);
            Stereotype ste = element.getAppliedStereotype(SysmlResource.RATE_ID);
            if (ste != null) {
                EObject steApplication = element.getStereotypeApplication(ste);
                itemPropertyDescriptorsForparameter.add((IItemPropertyDescriptor)this.createBase_ParameterPropertyDescriptorForParameter(steApplication));
                itemPropertyDescriptorsForparameter.add((IItemPropertyDescriptor)this.createBase_ParameterPropertyDescriptorForActivityEdge(steApplication));
                itemPropertyDescriptorsForparameter.add((IItemPropertyDescriptor)this.createBase_ActivityEdgePropertyDescriptorForParameter(steApplication));
                itemPropertyDescriptorsForparameter.add((IItemPropertyDescriptor)this.createBase_ActivityEdgePropertyDescriptorForActivityEdge(steApplication));
                itemPropertyDescriptorsForparameter.add((IItemPropertyDescriptor)this.createRatePropertyDescriptorForParameter(steApplication));
                itemPropertyDescriptorsForparameter.add((IItemPropertyDescriptor)this.createRatePropertyDescriptorForActivityEdge(steApplication));
            }
            return itemPropertyDescriptorsForparameter;
        }
        if (object instanceof ActivityEdge) {
            ActivityEdge element = (ActivityEdge)object;
            ArrayList<IItemPropertyDescriptor> itemPropertyDescriptorsForactivityEdge = new ArrayList<IItemPropertyDescriptor>();
            ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.ACTIVITY_EDGE);
            List propertyDescriptors = ite.getPropertyDescriptors((Object)this);
            itemPropertyDescriptorsForactivityEdge.addAll(propertyDescriptors);
            Stereotype ste = element.getAppliedStereotype(SysmlResource.RATE_ID);
            if (ste != null) {
                EObject steApplication = element.getStereotypeApplication(ste);
                itemPropertyDescriptorsForactivityEdge.add((IItemPropertyDescriptor)this.createBase_ParameterPropertyDescriptorForParameter(steApplication));
                itemPropertyDescriptorsForactivityEdge.add((IItemPropertyDescriptor)this.createBase_ParameterPropertyDescriptorForActivityEdge(steApplication));
                itemPropertyDescriptorsForactivityEdge.add((IItemPropertyDescriptor)this.createBase_ActivityEdgePropertyDescriptorForParameter(steApplication));
                itemPropertyDescriptorsForactivityEdge.add((IItemPropertyDescriptor)this.createBase_ActivityEdgePropertyDescriptorForActivityEdge(steApplication));
                itemPropertyDescriptorsForactivityEdge.add((IItemPropertyDescriptor)this.createRatePropertyDescriptorForParameter(steApplication));
                itemPropertyDescriptorsForactivityEdge.add((IItemPropertyDescriptor)this.createRatePropertyDescriptorForActivityEdge(steApplication));
            }
            return itemPropertyDescriptorsForactivityEdge;
        }
        return this.itemPropertyDescriptors;
    }

    protected void addBase_ParameterPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Rate_base_Parameter_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Rate_base_Parameter_feature", "_UI_Rate_type"), (EStructuralFeature)ActivitiesPackage.Literals.RATE__BASE_PARAMETER, true, false, true, null, null, null));
    }

    protected ItemPropertyDescriptorDecorator createBase_ParameterPropertyDescriptorForParameter(Object object) {
        return new ItemPropertyDescriptorDecorator(object, (IItemPropertyDescriptor)this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Rate_base_Parameter_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Rate_base_Parameter_feature", "_UI_Rate_type"), (EStructuralFeature)ActivitiesPackage.Literals.RATE__BASE_PARAMETER, true, false, true, null, null, null));
    }

    protected ItemPropertyDescriptorDecorator createBase_ParameterPropertyDescriptorForActivityEdge(Object object) {
        return new ItemPropertyDescriptorDecorator(object, (IItemPropertyDescriptor)this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Rate_base_Parameter_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Rate_base_Parameter_feature", "_UI_Rate_type"), (EStructuralFeature)ActivitiesPackage.Literals.RATE__BASE_PARAMETER, true, false, true, null, null, null));
    }

    protected void addBase_ActivityEdgePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Rate_base_ActivityEdge_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Rate_base_ActivityEdge_feature", "_UI_Rate_type"), (EStructuralFeature)ActivitiesPackage.Literals.RATE__BASE_ACTIVITY_EDGE, true, false, true, null, null, null));
    }

    protected ItemPropertyDescriptorDecorator createBase_ActivityEdgePropertyDescriptorForParameter(Object object) {
        return new ItemPropertyDescriptorDecorator(object, (IItemPropertyDescriptor)this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Rate_base_ActivityEdge_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Rate_base_ActivityEdge_feature", "_UI_Rate_type"), (EStructuralFeature)ActivitiesPackage.Literals.RATE__BASE_ACTIVITY_EDGE, true, false, true, null, null, null));
    }

    protected ItemPropertyDescriptorDecorator createBase_ActivityEdgePropertyDescriptorForActivityEdge(Object object) {
        return new ItemPropertyDescriptorDecorator(object, (IItemPropertyDescriptor)this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Rate_base_ActivityEdge_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Rate_base_ActivityEdge_feature", "_UI_Rate_type"), (EStructuralFeature)ActivitiesPackage.Literals.RATE__BASE_ACTIVITY_EDGE, true, false, true, null, null, null));
    }

    protected void addRatePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Rate_rate_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Rate_rate_feature", "_UI_Rate_type"), (EStructuralFeature)ActivitiesPackage.Literals.RATE__RATE, true, false, true, null, null, null));
    }

    protected ItemPropertyDescriptorDecorator createRatePropertyDescriptorForParameter(Object object) {
        return new ItemPropertyDescriptorDecorator(object, (IItemPropertyDescriptor)this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Rate_rate_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Rate_rate_feature", "_UI_Rate_type"), (EStructuralFeature)ActivitiesPackage.Literals.RATE__RATE, true, false, true, null, null, null));
    }

    protected ItemPropertyDescriptorDecorator createRatePropertyDescriptorForActivityEdge(Object object) {
        return new ItemPropertyDescriptorDecorator(object, (IItemPropertyDescriptor)this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Rate_rate_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Rate_rate_feature", "_UI_Rate_type"), (EStructuralFeature)ActivitiesPackage.Literals.RATE__RATE, true, false, true, null, null, null));
    }

    public Object getImage(Object object) {
        Object composedImage = this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Rate"));
        if (object instanceof NamedElement) {
            ComposedImage aux = new ComposedImage(Collections.singletonList(composedImage));
            return this.composeVisibilityImage(object, aux);
        }
        return composedImage;
    }

    public String getText(Object object) {
        Stereotype ste;
        Rate rate_ = null;
        if (object instanceof Parameter && (ste = ((Parameter)object).getAppliedStereotype(SysmlResource.RATE_ID)) != null) {
            IItemLabelProvider ite = (IItemLabelProvider)((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.PARAMETER);
            String result = ite.getText(object);
            result = RATE_PREFIX_PATTERN.matcher(result).replaceFirst("");
            return PARAMETER_PREFIX_PATTERN.matcher(result).replaceFirst("Rate");
        }
        if (object instanceof ActivityEdge && (ste = ((ActivityEdge)object).getAppliedStereotype(SysmlResource.RATE_ID)) != null) {
            IItemLabelProvider ite = (IItemLabelProvider)((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.ACTIVITY_EDGE);
            String result = ite.getText(object);
            result = RATE_PREFIX_PATTERN.matcher(result).replaceFirst("");
            return ACTIVITY_EDGE_PREFIX_PATTERN.matcher(result).replaceFirst("Rate");
        }
        rate_ = (Rate)object;
        return this.getString("_UI_Rate_type");
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        if (((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory() != null) {
            if (notification.getFeatureID(Parameter.class) != -1) {
                ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.PARAMETER);
                ite.notifyChanged(notification);
                return;
            }
            if (notification.getFeatureID(ActivityEdge.class) != -1) {
                ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.ACTIVITY_EDGE);
                ite.notifyChanged(notification);
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return SysmlEditPlugin.INSTANCE;
    }

    public Collection<?> getChildren(Object object) {
        Collection result = super.getChildren(object);
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory() != null) {
                if (UMLPackage.Literals.PARAMETER.equals(eObject.eClass())) {
                    ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.PARAMETER);
                    result.addAll(ite.getChildren(object));
                    return result;
                }
                if (UMLPackage.Literals.ACTIVITY_EDGE.equals(eObject.eClass())) {
                    ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.ACTIVITY_EDGE);
                    result.addAll(ite.getChildren(object));
                    return result;
                }
            }
        }
        return result;
    }

    public boolean hasChildren(Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory() != null) {
                if (UMLPackage.Literals.PARAMETER.equals(eObject.eClass())) {
                    ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.PARAMETER);
                    return super.hasChildren(object) || ite.hasChildren(object);
                }
                if (UMLPackage.Literals.ACTIVITY_EDGE.equals(eObject.eClass())) {
                    ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.ACTIVITY_EDGE);
                    return super.hasChildren(object) || ite.hasChildren(object);
                }
            }
        }
        return super.hasChildren(object);
    }
}

