/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.allocations.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptorDecorator;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.papyrus.sysml.allocations.Allocated;
import org.eclipse.papyrus.sysml.allocations.AllocationsPackage;
import org.eclipse.papyrus.sysml.edit.provider.IComposableAdapterFactory;
import org.eclipse.papyrus.sysml.edit.provider.SysMLItemProviderAdapter;
import org.eclipse.papyrus.sysml.provider.SysmlEditPlugin;
import org.eclipse.papyrus.sysml.util.SysmlResource;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AllocatedItemProvider
extends SysMLItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    private static Pattern ALLOCATED_PREFIX_PATTERN = Pattern.compile("(allocated, |<<allocated>>|, allocated)");
    private static Pattern NAMED_ELEMENT_PREFIX_PATTERN = Pattern.compile("Named Element");

    public AllocatedItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (object instanceof Allocated && this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addBase_NamedElementPropertyDescriptor(object);
            this.addAllocatedFromPropertyDescriptor(object);
            this.addAllocatedToPropertyDescriptor(object);
        }
        if (object instanceof NamedElement) {
            NamedElement element = (NamedElement)object;
            ArrayList<IItemPropertyDescriptor> itemPropertyDescriptorsFornamedElement = new ArrayList<IItemPropertyDescriptor>();
            ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.NAMED_ELEMENT);
            List propertyDescriptors = ite.getPropertyDescriptors((Object)this);
            itemPropertyDescriptorsFornamedElement.addAll(propertyDescriptors);
            Stereotype ste = element.getAppliedStereotype(SysmlResource.ALLOCATED_ID);
            if (ste != null) {
                EObject steApplication = element.getStereotypeApplication(ste);
                itemPropertyDescriptorsFornamedElement.add((IItemPropertyDescriptor)this.createBase_NamedElementPropertyDescriptorForNamedElement(steApplication));
                itemPropertyDescriptorsFornamedElement.add((IItemPropertyDescriptor)this.createAllocatedFromPropertyDescriptorForNamedElement(steApplication));
                itemPropertyDescriptorsFornamedElement.add((IItemPropertyDescriptor)this.createAllocatedToPropertyDescriptorForNamedElement(steApplication));
            }
            return itemPropertyDescriptorsFornamedElement;
        }
        return this.itemPropertyDescriptors;
    }

    protected void addBase_NamedElementPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Allocated_base_NamedElement_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Allocated_base_NamedElement_feature", "_UI_Allocated_type"), (EStructuralFeature)AllocationsPackage.Literals.ALLOCATED__BASE_NAMED_ELEMENT, true, false, true, null, null, null));
    }

    protected ItemPropertyDescriptorDecorator createBase_NamedElementPropertyDescriptorForNamedElement(Object object) {
        return new ItemPropertyDescriptorDecorator(object, (IItemPropertyDescriptor)this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Allocated_base_NamedElement_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Allocated_base_NamedElement_feature", "_UI_Allocated_type"), (EStructuralFeature)AllocationsPackage.Literals.ALLOCATED__BASE_NAMED_ELEMENT, true, false, true, null, null, null));
    }

    protected void addAllocatedFromPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Allocated_allocatedFrom_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Allocated_allocatedFrom_feature", "_UI_Allocated_type"), (EStructuralFeature)AllocationsPackage.Literals.ALLOCATED__ALLOCATED_FROM, false, false, false, null, null, null));
    }

    protected ItemPropertyDescriptorDecorator createAllocatedFromPropertyDescriptorForNamedElement(Object object) {
        return new ItemPropertyDescriptorDecorator(object, (IItemPropertyDescriptor)this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Allocated_allocatedFrom_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Allocated_allocatedFrom_feature", "_UI_Allocated_type"), (EStructuralFeature)AllocationsPackage.Literals.ALLOCATED__ALLOCATED_FROM, false, false, false, null, null, null));
    }

    protected void addAllocatedToPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Allocated_allocatedTo_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Allocated_allocatedTo_feature", "_UI_Allocated_type"), (EStructuralFeature)AllocationsPackage.Literals.ALLOCATED__ALLOCATED_TO, false, false, false, null, null, null));
    }

    protected ItemPropertyDescriptorDecorator createAllocatedToPropertyDescriptorForNamedElement(Object object) {
        return new ItemPropertyDescriptorDecorator(object, (IItemPropertyDescriptor)this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_Allocated_allocatedTo_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_Allocated_allocatedTo_feature", "_UI_Allocated_type"), (EStructuralFeature)AllocationsPackage.Literals.ALLOCATED__ALLOCATED_TO, false, false, false, null, null, null));
    }

    public Object getImage(Object object) {
        Object composedImage = this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Allocated"));
        if (object instanceof NamedElement) {
            ComposedImage aux = new ComposedImage(Collections.singletonList(composedImage));
            return this.composeVisibilityImage(object, aux);
        }
        return composedImage;
    }

    public String getText(Object object) {
        Stereotype ste;
        Allocated allocated_ = null;
        if (object instanceof NamedElement && (ste = ((NamedElement)object).getAppliedStereotype(SysmlResource.ALLOCATED_ID)) != null) {
            IItemLabelProvider ite = (IItemLabelProvider)((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.NAMED_ELEMENT);
            String result = ite.getText(object);
            result = ALLOCATED_PREFIX_PATTERN.matcher(result).replaceFirst("");
            return NAMED_ELEMENT_PREFIX_PATTERN.matcher(result).replaceFirst("Allocated");
        }
        allocated_ = (Allocated)object;
        return this.getString("_UI_Allocated_type");
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        if (((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory() != null && notification.getFeatureID(NamedElement.class) != -1) {
            ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.NAMED_ELEMENT);
            ite.notifyChanged(notification);
            return;
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return SysmlEditPlugin.INSTANCE;
    }

    public Collection<?> getChildren(Object object) {
        Collection result = super.getChildren(object);
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory() != null && UMLPackage.Literals.NAMED_ELEMENT.equals(eObject.eClass())) {
                ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.NAMED_ELEMENT);
                result.addAll(ite.getChildren(object));
                return result;
            }
        }
        return result;
    }

    public boolean hasChildren(Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory() != null && UMLPackage.Literals.NAMED_ELEMENT.equals(eObject.eClass())) {
                ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.NAMED_ELEMENT);
                return super.hasChildren(object) || ite.hasChildren(object);
            }
        }
        return super.hasChildren(object);
    }
}

