/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.blocks.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.papyrus.sysml.blocks.provider.BindingConnectorItemProvider;
import org.eclipse.papyrus.sysml.blocks.provider.BlockItemProvider;
import org.eclipse.papyrus.sysml.blocks.provider.ConnectorPropertyItemProvider;
import org.eclipse.papyrus.sysml.blocks.provider.DimensionItemProvider;
import org.eclipse.papyrus.sysml.blocks.provider.DistributedPropertyItemProvider;
import org.eclipse.papyrus.sysml.blocks.provider.NestedConnectorEndItemProvider;
import org.eclipse.papyrus.sysml.blocks.provider.ParticipantPropertyItemProvider;
import org.eclipse.papyrus.sysml.blocks.provider.PropertySpecificTypeItemProvider;
import org.eclipse.papyrus.sysml.blocks.provider.UnitItemProvider;
import org.eclipse.papyrus.sysml.blocks.provider.ValueTypeItemProvider;
import org.eclipse.papyrus.sysml.blocks.util.BlocksAdapterFactory;
import org.eclipse.papyrus.sysml.edit.provider.IComposableAdapterFactory;
import org.eclipse.papyrus.sysml.edit.provider.IRootAdapterFactory;

public class BlocksItemProviderAdapterFactory
extends BlocksAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IComposableAdapterFactory,
IDisposable {
    protected IRootAdapterFactory rootAdapterFactory;
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected Collection<Object> supportedTypes = new ArrayList<Object>();
    protected BlockItemProvider blockItemProvider;
    protected DistributedPropertyItemProvider distributedPropertyItemProvider;
    protected DimensionItemProvider dimensionItemProvider;
    protected UnitItemProvider unitItemProvider;
    protected ValueTypeItemProvider valueTypeItemProvider;
    protected NestedConnectorEndItemProvider nestedConnectorEndItemProvider;
    protected ParticipantPropertyItemProvider participantPropertyItemProvider;
    protected ConnectorPropertyItemProvider connectorPropertyItemProvider;
    protected BindingConnectorItemProvider bindingConnectorItemProvider;
    protected PropertySpecificTypeItemProvider propertySpecificTypeItemProvider;

    public IRootAdapterFactory getIRootAdapterFactory() {
        return this.rootAdapterFactory;
    }

    public void setRootAdapterFactory(IRootAdapterFactory root) {
        if (!(root instanceof IRootAdapterFactory)) {
            throw new RuntimeException(root + " do not implement IRootAdapterFactory");
        }
        this.rootAdapterFactory = root;
    }

    public BlocksItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    public Adapter createBlockAdapter() {
        if (this.blockItemProvider == null) {
            this.blockItemProvider = new BlockItemProvider((AdapterFactory)this);
        }
        return this.blockItemProvider;
    }

    public Adapter createDistributedPropertyAdapter() {
        if (this.distributedPropertyItemProvider == null) {
            this.distributedPropertyItemProvider = new DistributedPropertyItemProvider((AdapterFactory)this);
        }
        return this.distributedPropertyItemProvider;
    }

    public Adapter createDimensionAdapter() {
        if (this.dimensionItemProvider == null) {
            this.dimensionItemProvider = new DimensionItemProvider((AdapterFactory)this);
        }
        return this.dimensionItemProvider;
    }

    public Adapter createUnitAdapter() {
        if (this.unitItemProvider == null) {
            this.unitItemProvider = new UnitItemProvider((AdapterFactory)this);
        }
        return this.unitItemProvider;
    }

    public Adapter createValueTypeAdapter() {
        if (this.valueTypeItemProvider == null) {
            this.valueTypeItemProvider = new ValueTypeItemProvider((AdapterFactory)this);
        }
        return this.valueTypeItemProvider;
    }

    public Adapter createNestedConnectorEndAdapter() {
        if (this.nestedConnectorEndItemProvider == null) {
            this.nestedConnectorEndItemProvider = new NestedConnectorEndItemProvider((AdapterFactory)this);
        }
        return this.nestedConnectorEndItemProvider;
    }

    public Adapter createParticipantPropertyAdapter() {
        if (this.participantPropertyItemProvider == null) {
            this.participantPropertyItemProvider = new ParticipantPropertyItemProvider((AdapterFactory)this);
        }
        return this.participantPropertyItemProvider;
    }

    public Adapter createConnectorPropertyAdapter() {
        if (this.connectorPropertyItemProvider == null) {
            this.connectorPropertyItemProvider = new ConnectorPropertyItemProvider((AdapterFactory)this);
        }
        return this.connectorPropertyItemProvider;
    }

    public Adapter createBindingConnectorAdapter() {
        if (this.bindingConnectorItemProvider == null) {
            this.bindingConnectorItemProvider = new BindingConnectorItemProvider((AdapterFactory)this);
        }
        return this.bindingConnectorItemProvider;
    }

    public Adapter createPropertySpecificTypeAdapter() {
        if (this.propertySpecificTypeItemProvider == null) {
            this.propertySpecificTypeItemProvider = new PropertySpecificTypeItemProvider((AdapterFactory)this);
        }
        return this.propertySpecificTypeItemProvider;
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        if (this.blockItemProvider != null) {
            this.blockItemProvider.dispose();
        }
        if (this.distributedPropertyItemProvider != null) {
            this.distributedPropertyItemProvider.dispose();
        }
        if (this.dimensionItemProvider != null) {
            this.dimensionItemProvider.dispose();
        }
        if (this.unitItemProvider != null) {
            this.unitItemProvider.dispose();
        }
        if (this.valueTypeItemProvider != null) {
            this.valueTypeItemProvider.dispose();
        }
        if (this.nestedConnectorEndItemProvider != null) {
            this.nestedConnectorEndItemProvider.dispose();
        }
        if (this.participantPropertyItemProvider != null) {
            this.participantPropertyItemProvider.dispose();
        }
        if (this.connectorPropertyItemProvider != null) {
            this.connectorPropertyItemProvider.dispose();
        }
        if (this.bindingConnectorItemProvider != null) {
            this.bindingConnectorItemProvider.dispose();
        }
        if (this.propertySpecificTypeItemProvider != null) {
            this.propertySpecificTypeItemProvider.dispose();
        }
    }
}

