/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.blocks.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptorDecorator;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.papyrus.sysml.blocks.BlocksPackage;
import org.eclipse.papyrus.sysml.blocks.ValueType;
import org.eclipse.papyrus.sysml.edit.provider.IComposableAdapterFactory;
import org.eclipse.papyrus.sysml.edit.provider.SysMLItemProviderAdapter;
import org.eclipse.papyrus.sysml.provider.SysmlEditPlugin;
import org.eclipse.papyrus.sysml.util.SysmlResource;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueTypeItemProvider
extends SysMLItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    private static Pattern VALUE_TYPE_PREFIX_PATTERN = Pattern.compile("(valueType, |<<valueType>>|, valueType)");
    private static Pattern DATA_TYPE_PREFIX_PATTERN = Pattern.compile("Data Type");

    public ValueTypeItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (object instanceof ValueType && this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addBase_DataTypePropertyDescriptor(object);
            this.addUnitPropertyDescriptor(object);
            this.addDimensionPropertyDescriptor(object);
        }
        if (object instanceof DataType) {
            DataType element = (DataType)object;
            ArrayList<IItemPropertyDescriptor> itemPropertyDescriptorsFordataType = new ArrayList<IItemPropertyDescriptor>();
            ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.DATA_TYPE);
            List propertyDescriptors = ite.getPropertyDescriptors((Object)this);
            itemPropertyDescriptorsFordataType.addAll(propertyDescriptors);
            Stereotype ste = element.getAppliedStereotype(SysmlResource.VALUE_TYPE_ID);
            if (ste != null) {
                EObject steApplication = element.getStereotypeApplication(ste);
                itemPropertyDescriptorsFordataType.add((IItemPropertyDescriptor)this.createBase_DataTypePropertyDescriptorForDataType(steApplication));
                itemPropertyDescriptorsFordataType.add((IItemPropertyDescriptor)this.createUnitPropertyDescriptorForDataType(steApplication));
                itemPropertyDescriptorsFordataType.add((IItemPropertyDescriptor)this.createDimensionPropertyDescriptorForDataType(steApplication));
            }
            return itemPropertyDescriptorsFordataType;
        }
        return this.itemPropertyDescriptors;
    }

    protected void addBase_DataTypePropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ValueType_base_DataType_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ValueType_base_DataType_feature", "_UI_ValueType_type"), (EStructuralFeature)BlocksPackage.Literals.VALUE_TYPE__BASE_DATA_TYPE, true, false, true, null, null, null));
    }

    protected ItemPropertyDescriptorDecorator createBase_DataTypePropertyDescriptorForDataType(Object object) {
        return new ItemPropertyDescriptorDecorator(object, (IItemPropertyDescriptor)this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ValueType_base_DataType_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ValueType_base_DataType_feature", "_UI_ValueType_type"), (EStructuralFeature)BlocksPackage.Literals.VALUE_TYPE__BASE_DATA_TYPE, true, false, true, null, null, null));
    }

    protected void addUnitPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ValueType_unit_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ValueType_unit_feature", "_UI_ValueType_type"), (EStructuralFeature)BlocksPackage.Literals.VALUE_TYPE__UNIT, true, false, true, null, null, null));
    }

    protected ItemPropertyDescriptorDecorator createUnitPropertyDescriptorForDataType(Object object) {
        return new ItemPropertyDescriptorDecorator(object, (IItemPropertyDescriptor)this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ValueType_unit_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ValueType_unit_feature", "_UI_ValueType_type"), (EStructuralFeature)BlocksPackage.Literals.VALUE_TYPE__UNIT, true, false, true, null, null, null));
    }

    protected void addDimensionPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ValueType_dimension_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ValueType_dimension_feature", "_UI_ValueType_type"), (EStructuralFeature)BlocksPackage.Literals.VALUE_TYPE__DIMENSION, true, false, true, null, null, null));
    }

    protected ItemPropertyDescriptorDecorator createDimensionPropertyDescriptorForDataType(Object object) {
        return new ItemPropertyDescriptorDecorator(object, (IItemPropertyDescriptor)this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_ValueType_dimension_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_ValueType_dimension_feature", "_UI_ValueType_type"), (EStructuralFeature)BlocksPackage.Literals.VALUE_TYPE__DIMENSION, true, false, true, null, null, null));
    }

    public Object getImage(Object object) {
        Object composedImage = this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/ValueType"));
        if (object instanceof NamedElement) {
            ComposedImage aux = new ComposedImage(Collections.singletonList(composedImage));
            return this.composeVisibilityImage(object, aux);
        }
        return composedImage;
    }

    public String getText(Object object) {
        Stereotype ste;
        ValueType valueType_ = null;
        if (object instanceof DataType && (ste = ((DataType)object).getAppliedStereotype(SysmlResource.VALUE_TYPE_ID)) != null) {
            IItemLabelProvider ite = (IItemLabelProvider)((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.DATA_TYPE);
            String result = ite.getText(object);
            result = VALUE_TYPE_PREFIX_PATTERN.matcher(result).replaceFirst("");
            return DATA_TYPE_PREFIX_PATTERN.matcher(result).replaceFirst("ValueType");
        }
        valueType_ = (ValueType)object;
        return this.getString("_UI_ValueType_type");
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        if (((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory() != null && notification.getFeatureID(DataType.class) != -1) {
            ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.DATA_TYPE);
            ite.notifyChanged(notification);
            return;
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return SysmlEditPlugin.INSTANCE;
    }

    public Collection<?> getChildren(Object object) {
        Collection result = super.getChildren(object);
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory() != null && UMLPackage.Literals.DATA_TYPE.equals(eObject.eClass())) {
                ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.DATA_TYPE);
                result.addAll(ite.getChildren(object));
                return result;
            }
        }
        return result;
    }

    public boolean hasChildren(Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory() != null && UMLPackage.Literals.DATA_TYPE.equals(eObject.eClass())) {
                ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.DATA_TYPE);
                return super.hasChildren(object) || ite.hasChildren(object);
            }
        }
        return super.hasChildren(object);
    }
}

