/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.constraints.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.papyrus.sysml.blocks.provider.BlockItemProvider;
import org.eclipse.papyrus.sysml.constraints.ConstraintBlock;
import org.eclipse.papyrus.sysml.edit.provider.IComposableAdapterFactory;
import org.eclipse.papyrus.sysml.edit.provider.IVisibilityOverlayImage;
import org.eclipse.papyrus.sysml.provider.SysmlEditPlugin;
import org.eclipse.papyrus.sysml.util.SysmlResource;
import org.eclipse.uml2.uml.Class;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.edit.UMLEditPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConstraintBlockItemProvider
extends BlockItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
IVisibilityOverlayImage {
    private static Pattern CONSTRAINT_BLOCK_PREFIX_PATTERN = Pattern.compile("(constraintBlock, |<<constraintBlock>>|, constraintBlock)");
    private static Pattern CLASS_PREFIX_PATTERN = Pattern.compile("Class");

    public ConstraintBlockItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    @Override
    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (object instanceof ConstraintBlock && this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
        }
        if (object instanceof Class) {
            Class element = (Class)object;
            ArrayList<IItemPropertyDescriptor> itemPropertyDescriptorsForclass = new ArrayList<IItemPropertyDescriptor>();
            ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.CLASS);
            List propertyDescriptors = ite.getPropertyDescriptors((Object)this);
            itemPropertyDescriptorsForclass.addAll(propertyDescriptors);
            Stereotype ste = element.getAppliedStereotype(SysmlResource.CONSTRAINT_BLOCK_ID);
            if (ste != null) {
                EObject eObject = element.getStereotypeApplication(ste);
            }
            return itemPropertyDescriptorsForclass;
        }
        return this.itemPropertyDescriptors;
    }

    @Override
    public Object getImage(Object object) {
        Object composedImage = this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/ConstraintBlock"));
        if (object instanceof NamedElement) {
            ComposedImage aux = new ComposedImage(Collections.singletonList(composedImage));
            return this.composeVisibilityImage(object, aux);
        }
        return composedImage;
    }

    @Override
    public String getText(Object object) {
        Stereotype ste;
        ConstraintBlock constraintBlock_ = null;
        if (object instanceof Class && (ste = ((Class)object).getAppliedStereotype(SysmlResource.CONSTRAINT_BLOCK_ID)) != null) {
            IItemLabelProvider ite = (IItemLabelProvider)((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.CLASS);
            String result = ite.getText(object);
            result = CONSTRAINT_BLOCK_PREFIX_PATTERN.matcher(result).replaceFirst("");
            return CLASS_PREFIX_PATTERN.matcher(result).replaceFirst("ConstraintBlock");
        }
        ConstraintBlock constraintBlock = constraintBlock_ = (ConstraintBlock)object;
        return String.valueOf(this.getString("_UI_ConstraintBlock_type")) + " " + constraintBlock.isIsEncapsulated();
    }

    @Override
    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        if (((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory() != null && notification.getFeatureID(Class.class) != -1) {
            ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.CLASS);
            ite.notifyChanged(notification);
            return;
        }
        super.notifyChanged(notification);
    }

    @Override
    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    @Override
    public ResourceLocator getResourceLocator() {
        return SysmlEditPlugin.INSTANCE;
    }

    @Override
    public ComposedImage composeVisibilityImage(Object object, ComposedImage composedImage) {
        NamedElement namedElement = (NamedElement)object;
        if (namedElement.isSetVisibility()) {
            composedImage.getImages().add(UMLEditPlugin.INSTANCE.getImage("full/ovr16/VisibilityKind_" + namedElement.getVisibility().getName()));
        }
        return composedImage;
    }

    @Override
    public Collection<?> getChildren(Object object) {
        Collection<?> result = super.getChildren(object);
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory() != null && UMLPackage.Literals.CLASS.equals(eObject.eClass())) {
                ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.CLASS);
                result.addAll(ite.getChildren(object));
                return result;
            }
        }
        return result;
    }

    @Override
    public boolean hasChildren(Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory() != null && UMLPackage.Literals.CLASS.equals(eObject.eClass())) {
                ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.CLASS);
                return super.hasChildren(object) || ite.hasChildren(object);
            }
        }
        return super.hasChildren(object);
    }
}

