/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.portandflows.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.papyrus.sysml.edit.provider.IComposableAdapterFactory;
import org.eclipse.papyrus.sysml.edit.provider.IRootAdapterFactory;
import org.eclipse.papyrus.sysml.portandflows.provider.FlowPortItemProvider;
import org.eclipse.papyrus.sysml.portandflows.provider.FlowPropertyItemProvider;
import org.eclipse.papyrus.sysml.portandflows.provider.FlowSpecificationItemProvider;
import org.eclipse.papyrus.sysml.portandflows.provider.ItemFlowItemProvider;
import org.eclipse.papyrus.sysml.portandflows.util.PortandflowsAdapterFactory;

public class PortandflowsItemProviderAdapterFactory
extends PortandflowsAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IComposableAdapterFactory,
IDisposable {
    protected IRootAdapterFactory rootAdapterFactory;
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected Collection<Object> supportedTypes = new ArrayList<Object>();
    protected FlowPortItemProvider flowPortItemProvider;
    protected FlowPropertyItemProvider flowPropertyItemProvider;
    protected FlowSpecificationItemProvider flowSpecificationItemProvider;
    protected ItemFlowItemProvider itemFlowItemProvider;

    public IRootAdapterFactory getIRootAdapterFactory() {
        return this.rootAdapterFactory;
    }

    public void setRootAdapterFactory(IRootAdapterFactory root) {
        if (!(root instanceof IRootAdapterFactory)) {
            throw new RuntimeException(root + " do not implement IRootAdapterFactory");
        }
        this.rootAdapterFactory = root;
    }

    public PortandflowsItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    public Adapter createFlowPortAdapter() {
        if (this.flowPortItemProvider == null) {
            this.flowPortItemProvider = new FlowPortItemProvider((AdapterFactory)this);
        }
        return this.flowPortItemProvider;
    }

    public Adapter createFlowPropertyAdapter() {
        if (this.flowPropertyItemProvider == null) {
            this.flowPropertyItemProvider = new FlowPropertyItemProvider((AdapterFactory)this);
        }
        return this.flowPropertyItemProvider;
    }

    public Adapter createFlowSpecificationAdapter() {
        if (this.flowSpecificationItemProvider == null) {
            this.flowSpecificationItemProvider = new FlowSpecificationItemProvider((AdapterFactory)this);
        }
        return this.flowSpecificationItemProvider;
    }

    public Adapter createItemFlowAdapter() {
        if (this.itemFlowItemProvider == null) {
            this.itemFlowItemProvider = new ItemFlowItemProvider((AdapterFactory)this);
        }
        return this.itemFlowItemProvider;
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        if (this.flowPortItemProvider != null) {
            this.flowPortItemProvider.dispose();
        }
        if (this.flowPropertyItemProvider != null) {
            this.flowPropertyItemProvider.dispose();
        }
        if (this.flowSpecificationItemProvider != null) {
            this.flowSpecificationItemProvider.dispose();
        }
        if (this.itemFlowItemProvider != null) {
            this.itemFlowItemProvider.dispose();
        }
    }
}

