/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.registry;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.papyrus.sysml.activities.provider.ActivitiesItemProviderAdapterFactory;
import org.eclipse.papyrus.sysml.allocations.provider.AllocationsItemProviderAdapterFactory;
import org.eclipse.papyrus.sysml.blocks.provider.BlocksItemProviderAdapterFactory;
import org.eclipse.papyrus.sysml.constraints.provider.ConstraintsItemProviderAdapterFactory;
import org.eclipse.papyrus.sysml.edit.provider.IComposableAdapterFactory;
import org.eclipse.papyrus.sysml.edit.provider.IRootAdapterFactory;
import org.eclipse.papyrus.sysml.modelelements.provider.ModelelementsItemProviderAdapterFactory;
import org.eclipse.papyrus.sysml.portandflows.provider.PortandflowsItemProviderAdapterFactory;
import org.eclipse.papyrus.sysml.requirements.provider.RequirementsItemProviderAdapterFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.edit.providers.AbstractionItemProvider;
import org.eclipse.uml2.uml.edit.providers.ActivityEdgeItemProvider;
import org.eclipse.uml2.uml.edit.providers.ActivityPartitionItemProvider;
import org.eclipse.uml2.uml.edit.providers.BehaviorItemProvider;
import org.eclipse.uml2.uml.edit.providers.ClassItemProvider;
import org.eclipse.uml2.uml.edit.providers.ClassifierItemProvider;
import org.eclipse.uml2.uml.edit.providers.CommentItemProvider;
import org.eclipse.uml2.uml.edit.providers.ConnectorEndItemProvider;
import org.eclipse.uml2.uml.edit.providers.ConnectorItemProvider;
import org.eclipse.uml2.uml.edit.providers.DataTypeItemProvider;
import org.eclipse.uml2.uml.edit.providers.DependencyItemProvider;
import org.eclipse.uml2.uml.edit.providers.InformationFlowItemProvider;
import org.eclipse.uml2.uml.edit.providers.InstanceSpecificationItemProvider;
import org.eclipse.uml2.uml.edit.providers.InterfaceItemProvider;
import org.eclipse.uml2.uml.edit.providers.NamedElementItemProvider;
import org.eclipse.uml2.uml.edit.providers.ObjectNodeItemProvider;
import org.eclipse.uml2.uml.edit.providers.OperationItemProvider;
import org.eclipse.uml2.uml.edit.providers.PackageItemProvider;
import org.eclipse.uml2.uml.edit.providers.ParameterItemProvider;
import org.eclipse.uml2.uml.edit.providers.ParameterSetItemProvider;
import org.eclipse.uml2.uml.edit.providers.PortItemProvider;
import org.eclipse.uml2.uml.edit.providers.PropertyItemProvider;
import org.eclipse.uml2.uml.edit.providers.UMLItemProviderAdapterFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SysmlRegistryAdapterFactoryRegistry {
    protected ModelelementsItemProviderAdapterFactory modelelementsAdapterFactoryItemProvider;
    protected BlocksItemProviderAdapterFactory blocksAdapterFactoryItemProvider;
    protected PortandflowsItemProviderAdapterFactory portandflowsAdapterFactoryItemProvider;
    protected ConstraintsItemProviderAdapterFactory constraintsAdapterFactoryItemProvider;
    protected ActivitiesItemProviderAdapterFactory activitiesAdapterFactoryItemProvider;
    protected AllocationsItemProviderAdapterFactory allocationsAdapterFactoryItemProvider;
    protected RequirementsItemProviderAdapterFactory requirementsAdapterFactoryItemProvider;
    private List<AdapterFactory> adapterFactoryRegistry = new ArrayList<AdapterFactory>(7);
    private HashMap<EClass, ArrayList<AdapterFactory>> adapterFactoryRegistryMap = new HashMap();
    private UMLItemProviderAdapterFactory defaultAdapterFactory = new UMLItemProviderAdapterFactory();

    private SysmlRegistryAdapterFactoryRegistry() {
        this.modelelementsAdapterFactoryItemProvider = new ModelelementsItemProviderAdapterFactory();
        this.adapterFactoryRegistry.add((AdapterFactory)this.modelelementsAdapterFactoryItemProvider);
        this.blocksAdapterFactoryItemProvider = new BlocksItemProviderAdapterFactory();
        this.adapterFactoryRegistry.add((AdapterFactory)this.blocksAdapterFactoryItemProvider);
        this.portandflowsAdapterFactoryItemProvider = new PortandflowsItemProviderAdapterFactory();
        this.adapterFactoryRegistry.add((AdapterFactory)this.portandflowsAdapterFactoryItemProvider);
        this.constraintsAdapterFactoryItemProvider = new ConstraintsItemProviderAdapterFactory();
        this.adapterFactoryRegistry.add((AdapterFactory)this.constraintsAdapterFactoryItemProvider);
        this.activitiesAdapterFactoryItemProvider = new ActivitiesItemProviderAdapterFactory();
        this.adapterFactoryRegistry.add((AdapterFactory)this.activitiesAdapterFactoryItemProvider);
        this.allocationsAdapterFactoryItemProvider = new AllocationsItemProviderAdapterFactory();
        this.adapterFactoryRegistry.add((AdapterFactory)this.allocationsAdapterFactoryItemProvider);
        this.requirementsAdapterFactoryItemProvider = new RequirementsItemProviderAdapterFactory();
        this.adapterFactoryRegistry.add((AdapterFactory)this.requirementsAdapterFactoryItemProvider);
        this.adapterFactoryRegistryMap.put(UMLPackage.Literals.ABSTRACTION, new ArrayList<RequirementsItemProviderAdapterFactory>(Collections.singletonList(this.requirementsAdapterFactoryItemProvider)));
        this.adapterFactoryRegistryMap.get(UMLPackage.Literals.ABSTRACTION).add((AdapterFactory)this.allocationsAdapterFactoryItemProvider);
        this.adapterFactoryRegistryMap.put(UMLPackage.Literals.ACTIVITY_EDGE, new ArrayList<ActivitiesItemProviderAdapterFactory>(Collections.singletonList(this.activitiesAdapterFactoryItemProvider)));
        this.adapterFactoryRegistryMap.put(UMLPackage.Literals.ACTIVITY_PARTITION, new ArrayList<AllocationsItemProviderAdapterFactory>(Collections.singletonList(this.allocationsAdapterFactoryItemProvider)));
        this.adapterFactoryRegistryMap.put(UMLPackage.Literals.BEHAVIOR, new ArrayList<RequirementsItemProviderAdapterFactory>(Collections.singletonList(this.requirementsAdapterFactoryItemProvider)));
        this.adapterFactoryRegistryMap.get(UMLPackage.Literals.BEHAVIOR).add((AdapterFactory)this.activitiesAdapterFactoryItemProvider);
        this.adapterFactoryRegistryMap.put(UMLPackage.Literals.CLASS, new ArrayList<RequirementsItemProviderAdapterFactory>(Collections.singletonList(this.requirementsAdapterFactoryItemProvider)));
        this.adapterFactoryRegistryMap.get(UMLPackage.Literals.CLASS).add((AdapterFactory)this.modelelementsAdapterFactoryItemProvider);
        this.adapterFactoryRegistryMap.get(UMLPackage.Literals.CLASS).add((AdapterFactory)this.blocksAdapterFactoryItemProvider);
        this.adapterFactoryRegistryMap.get(UMLPackage.Literals.CLASS).add((AdapterFactory)this.constraintsAdapterFactoryItemProvider);
        this.adapterFactoryRegistryMap.put(UMLPackage.Literals.CLASSIFIER, new ArrayList<BlocksItemProviderAdapterFactory>(Collections.singletonList(this.blocksAdapterFactoryItemProvider)));
        this.adapterFactoryRegistryMap.put(UMLPackage.Literals.COMMENT, new ArrayList<ModelelementsItemProviderAdapterFactory>(Collections.singletonList(this.modelelementsAdapterFactoryItemProvider)));
        this.adapterFactoryRegistryMap.put(UMLPackage.Literals.CONNECTOR, new ArrayList<BlocksItemProviderAdapterFactory>(Collections.singletonList(this.blocksAdapterFactoryItemProvider)));
        this.adapterFactoryRegistryMap.put(UMLPackage.Literals.CONNECTOR_END, new ArrayList<BlocksItemProviderAdapterFactory>(Collections.singletonList(this.blocksAdapterFactoryItemProvider)));
        this.adapterFactoryRegistryMap.put(UMLPackage.Literals.DATA_TYPE, new ArrayList<BlocksItemProviderAdapterFactory>(Collections.singletonList(this.blocksAdapterFactoryItemProvider)));
        this.adapterFactoryRegistryMap.put(UMLPackage.Literals.DEPENDENCY, new ArrayList<ModelelementsItemProviderAdapterFactory>(Collections.singletonList(this.modelelementsAdapterFactoryItemProvider)));
        this.adapterFactoryRegistryMap.put(UMLPackage.Literals.INFORMATION_FLOW, new ArrayList<PortandflowsItemProviderAdapterFactory>(Collections.singletonList(this.portandflowsAdapterFactoryItemProvider)));
        this.adapterFactoryRegistryMap.put(UMLPackage.Literals.INSTANCE_SPECIFICATION, new ArrayList<BlocksItemProviderAdapterFactory>(Collections.singletonList(this.blocksAdapterFactoryItemProvider)));
        this.adapterFactoryRegistryMap.put(UMLPackage.Literals.INTERFACE, new ArrayList<PortandflowsItemProviderAdapterFactory>(Collections.singletonList(this.portandflowsAdapterFactoryItemProvider)));
        this.adapterFactoryRegistryMap.put(UMLPackage.Literals.NAMED_ELEMENT, new ArrayList<RequirementsItemProviderAdapterFactory>(Collections.singletonList(this.requirementsAdapterFactoryItemProvider)));
        this.adapterFactoryRegistryMap.get(UMLPackage.Literals.NAMED_ELEMENT).add((AdapterFactory)this.allocationsAdapterFactoryItemProvider);
        this.adapterFactoryRegistryMap.put(UMLPackage.Literals.OBJECT_NODE, new ArrayList<ActivitiesItemProviderAdapterFactory>(Collections.singletonList(this.activitiesAdapterFactoryItemProvider)));
        this.adapterFactoryRegistryMap.put(UMLPackage.Literals.OPERATION, new ArrayList<RequirementsItemProviderAdapterFactory>(Collections.singletonList(this.requirementsAdapterFactoryItemProvider)));
        this.adapterFactoryRegistryMap.get(UMLPackage.Literals.OPERATION).add((AdapterFactory)this.activitiesAdapterFactoryItemProvider);
        this.adapterFactoryRegistryMap.put(UMLPackage.Literals.PACKAGE, new ArrayList<ModelelementsItemProviderAdapterFactory>(Collections.singletonList(this.modelelementsAdapterFactoryItemProvider)));
        this.adapterFactoryRegistryMap.put(UMLPackage.Literals.PARAMETER, new ArrayList<ActivitiesItemProviderAdapterFactory>(Collections.singletonList(this.activitiesAdapterFactoryItemProvider)));
        this.adapterFactoryRegistryMap.put(UMLPackage.Literals.PARAMETER_SET, new ArrayList<ActivitiesItemProviderAdapterFactory>(Collections.singletonList(this.activitiesAdapterFactoryItemProvider)));
        this.adapterFactoryRegistryMap.put(UMLPackage.Literals.PORT, new ArrayList<PortandflowsItemProviderAdapterFactory>(Collections.singletonList(this.portandflowsAdapterFactoryItemProvider)));
        this.adapterFactoryRegistryMap.put(UMLPackage.Literals.PROPERTY, new ArrayList<PortandflowsItemProviderAdapterFactory>(Collections.singletonList(this.portandflowsAdapterFactoryItemProvider)));
        this.adapterFactoryRegistryMap.get(UMLPackage.Literals.PROPERTY).add((AdapterFactory)this.blocksAdapterFactoryItemProvider);
        this.adapterFactoryRegistryMap.get(UMLPackage.Literals.PROPERTY).add((AdapterFactory)this.constraintsAdapterFactoryItemProvider);
    }

    public static SysmlRegistryAdapterFactoryRegistry getSingleton() {
        return SingletonHolder.instance;
    }

    public AdapterFactory getDefaultAdapterFactory() {
        return this.defaultAdapterFactory;
    }

    public List<AdapterFactory> getAdapterFactoriesForType(Object element) {
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            ArrayList<AdapterFactory> result = this.adapterFactoryRegistryMap.get(eObject.eClass());
            if (result != null) {
                return result;
            }
            return Collections.singletonList(this.getDefaultAdapterFactory());
        }
        throw new RuntimeException("org.eclipse.papyrus.sysml.edit.utils.SysmlRegistryAdapterFactoryRegistery : This factory only works with EOBjects");
    }

    public void setRootAdapterFactory(IRootAdapterFactory adapter) {
        for (AdapterFactory adap : this.adapterFactoryRegistry) {
            if (!(adap instanceof IComposableAdapterFactory)) continue;
            ((IComposableAdapterFactory)adap).setRootAdapterFactory(adapter);
        }
    }

    public HashMap<EClass, ItemProviderAdapter> getUMLItemProviderClassifedByUMLElement(AdapterFactory rootAdapterFactory) {
        HashMap<EClass, ItemProviderAdapter> result = new HashMap<EClass, ItemProviderAdapter>();
        result.put(UMLPackage.Literals.OBJECT_NODE, (ItemProviderAdapter)new ObjectNodeItemProvider(rootAdapterFactory));
        result.put(UMLPackage.Literals.CONNECTOR_END, (ItemProviderAdapter)new ConnectorEndItemProvider(rootAdapterFactory));
        result.put(UMLPackage.Literals.INFORMATION_FLOW, (ItemProviderAdapter)new InformationFlowItemProvider(rootAdapterFactory));
        result.put(UMLPackage.Literals.DEPENDENCY, (ItemProviderAdapter)new DependencyItemProvider(rootAdapterFactory));
        result.put(UMLPackage.Literals.DATA_TYPE, (ItemProviderAdapter)new DataTypeItemProvider(rootAdapterFactory));
        result.put(UMLPackage.Literals.ABSTRACTION, (ItemProviderAdapter)new AbstractionItemProvider(rootAdapterFactory));
        result.put(UMLPackage.Literals.PARAMETER, (ItemProviderAdapter)new ParameterItemProvider(rootAdapterFactory));
        result.put(UMLPackage.Literals.CLASS, (ItemProviderAdapter)new ClassItemProvider(rootAdapterFactory));
        result.put(UMLPackage.Literals.COMMENT, (ItemProviderAdapter)new CommentItemProvider(rootAdapterFactory));
        result.put(UMLPackage.Literals.BEHAVIOR, (ItemProviderAdapter)new BehaviorItemProvider(rootAdapterFactory));
        result.put(UMLPackage.Literals.PROPERTY, (ItemProviderAdapter)new PropertyItemProvider(rootAdapterFactory));
        result.put(UMLPackage.Literals.PACKAGE, (ItemProviderAdapter)new PackageItemProvider(rootAdapterFactory));
        result.put(UMLPackage.Literals.CONNECTOR, (ItemProviderAdapter)new ConnectorItemProvider(rootAdapterFactory));
        result.put(UMLPackage.Literals.INSTANCE_SPECIFICATION, (ItemProviderAdapter)new InstanceSpecificationItemProvider(rootAdapterFactory));
        result.put(UMLPackage.Literals.INTERFACE, (ItemProviderAdapter)new InterfaceItemProvider(rootAdapterFactory));
        result.put(UMLPackage.Literals.OPERATION, (ItemProviderAdapter)new OperationItemProvider(rootAdapterFactory));
        result.put(UMLPackage.Literals.NAMED_ELEMENT, (ItemProviderAdapter)new NamedElementItemProvider(rootAdapterFactory));
        result.put(UMLPackage.Literals.PARAMETER_SET, (ItemProviderAdapter)new ParameterSetItemProvider(rootAdapterFactory));
        result.put(UMLPackage.Literals.CLASSIFIER, (ItemProviderAdapter)new ClassifierItemProvider(rootAdapterFactory));
        result.put(UMLPackage.Literals.ACTIVITY_PARTITION, (ItemProviderAdapter)new ActivityPartitionItemProvider(rootAdapterFactory));
        result.put(UMLPackage.Literals.ACTIVITY_EDGE, (ItemProviderAdapter)new ActivityEdgeItemProvider(rootAdapterFactory));
        result.put(UMLPackage.Literals.PORT, (ItemProviderAdapter)new PortItemProvider(rootAdapterFactory));
        return result;
    }

    /* synthetic */ SysmlRegistryAdapterFactoryRegistry(SysmlRegistryAdapterFactoryRegistry sysmlRegistryAdapterFactoryRegistry) {
        this();
    }

    private static class SingletonHolder {
        protected static SysmlRegistryAdapterFactoryRegistry instance = null;

        static {
            instance = new SysmlRegistryAdapterFactoryRegistry(null);
        }

        private SingletonHolder() {
        }
    }
}

