/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.requirements.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.papyrus.sysml.edit.provider.IComposableAdapterFactory;
import org.eclipse.papyrus.sysml.edit.provider.IVisibilityOverlayImage;
import org.eclipse.papyrus.sysml.provider.SysmlEditPlugin;
import org.eclipse.papyrus.sysml.requirements.Copy;
import org.eclipse.papyrus.sysml.util.SysmlResource;
import org.eclipse.papyrus.uml.standard.provider.TraceItemProvider;
import org.eclipse.uml2.uml.Abstraction;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.edit.UMLEditPlugin;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CopyItemProvider
extends TraceItemProvider
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
IVisibilityOverlayImage {
    private static Pattern COPY_PREFIX_PATTERN = Pattern.compile("(copy, |<<copy>>|, copy)");
    private static Pattern ABSTRACTION_PREFIX_PATTERN = Pattern.compile("Abstraction");

    public CopyItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (object instanceof Copy && this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
        }
        if (object instanceof Abstraction) {
            Abstraction element = (Abstraction)object;
            ArrayList<IItemPropertyDescriptor> itemPropertyDescriptorsForabstraction = new ArrayList<IItemPropertyDescriptor>();
            ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.ABSTRACTION);
            List propertyDescriptors = ite.getPropertyDescriptors((Object)this);
            itemPropertyDescriptorsForabstraction.addAll(propertyDescriptors);
            Stereotype ste = element.getAppliedStereotype(SysmlResource.COPY_ID);
            if (ste != null) {
                EObject eObject = element.getStereotypeApplication(ste);
            }
            return itemPropertyDescriptorsForabstraction;
        }
        return this.itemPropertyDescriptors;
    }

    public Object getImage(Object object) {
        Object composedImage = this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/Copy"));
        if (object instanceof NamedElement) {
            ComposedImage aux = new ComposedImage(Collections.singletonList(composedImage));
            return this.composeVisibilityImage(object, aux);
        }
        return composedImage;
    }

    public String getText(Object object) {
        Stereotype ste;
        Copy copy_ = null;
        if (object instanceof Abstraction && (ste = ((Abstraction)object).getAppliedStereotype(SysmlResource.COPY_ID)) != null) {
            IItemLabelProvider ite = (IItemLabelProvider)((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.ABSTRACTION);
            String result = ite.getText(object);
            result = COPY_PREFIX_PATTERN.matcher(result).replaceFirst("");
            return ABSTRACTION_PREFIX_PATTERN.matcher(result).replaceFirst("Copy");
        }
        copy_ = (Copy)object;
        return this.getString("_UI_Copy_type");
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        if (((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory() != null && notification.getFeatureID(Abstraction.class) != -1) {
            ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.ABSTRACTION);
            ite.notifyChanged(notification);
            return;
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return SysmlEditPlugin.INSTANCE;
    }

    @Override
    public ComposedImage composeVisibilityImage(Object object, ComposedImage composedImage) {
        NamedElement namedElement = (NamedElement)object;
        if (namedElement.isSetVisibility()) {
            composedImage.getImages().add(UMLEditPlugin.INSTANCE.getImage("full/ovr16/VisibilityKind_" + namedElement.getVisibility().getName()));
        }
        return composedImage;
    }

    public Collection<?> getChildren(Object object) {
        Collection result = super.getChildren(object);
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory() != null && UMLPackage.Literals.ABSTRACTION.equals(eObject.eClass())) {
                ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.ABSTRACTION);
                result.addAll(ite.getChildren(object));
                return result;
            }
        }
        return result;
    }

    public boolean hasChildren(Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory() != null && UMLPackage.Literals.ABSTRACTION.equals(eObject.eClass())) {
                ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.ABSTRACTION);
                return super.hasChildren(object) || ite.hasChildren(object);
            }
        }
        return super.hasChildren(object);
    }
}

