/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.requirements.provider;

import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.papyrus.sysml.edit.provider.IComposableAdapterFactory;
import org.eclipse.papyrus.sysml.edit.provider.IRootAdapterFactory;
import org.eclipse.papyrus.sysml.requirements.provider.CopyItemProvider;
import org.eclipse.papyrus.sysml.requirements.provider.DeriveReqtItemProvider;
import org.eclipse.papyrus.sysml.requirements.provider.RequirementItemProvider;
import org.eclipse.papyrus.sysml.requirements.provider.RequirementRelatedItemProvider;
import org.eclipse.papyrus.sysml.requirements.provider.SatisfyItemProvider;
import org.eclipse.papyrus.sysml.requirements.provider.TestCaseItemProvider;
import org.eclipse.papyrus.sysml.requirements.provider.VerifyItemProvider;
import org.eclipse.papyrus.sysml.requirements.util.RequirementsAdapterFactory;

public class RequirementsItemProviderAdapterFactory
extends RequirementsAdapterFactory
implements ComposeableAdapterFactory,
IChangeNotifier,
IComposableAdapterFactory,
IDisposable {
    protected IRootAdapterFactory rootAdapterFactory;
    protected ComposedAdapterFactory parentAdapterFactory;
    protected IChangeNotifier changeNotifier = new ChangeNotifier();
    protected Collection<Object> supportedTypes = new ArrayList<Object>();
    protected DeriveReqtItemProvider deriveReqtItemProvider;
    protected VerifyItemProvider verifyItemProvider;
    protected CopyItemProvider copyItemProvider;
    protected SatisfyItemProvider satisfyItemProvider;
    protected TestCaseItemProvider testCaseItemProvider;
    protected RequirementItemProvider requirementItemProvider;
    protected RequirementRelatedItemProvider requirementRelatedItemProvider;

    public IRootAdapterFactory getIRootAdapterFactory() {
        return this.rootAdapterFactory;
    }

    public void setRootAdapterFactory(IRootAdapterFactory root) {
        if (!(root instanceof IRootAdapterFactory)) {
            throw new RuntimeException(root + " do not implement IRootAdapterFactory");
        }
        this.rootAdapterFactory = root;
    }

    public RequirementsItemProviderAdapterFactory() {
        this.supportedTypes.add(IEditingDomainItemProvider.class);
        this.supportedTypes.add(IStructuredItemContentProvider.class);
        this.supportedTypes.add(ITreeItemContentProvider.class);
        this.supportedTypes.add(IItemLabelProvider.class);
        this.supportedTypes.add(IItemPropertySource.class);
    }

    public Adapter createDeriveReqtAdapter() {
        if (this.deriveReqtItemProvider == null) {
            this.deriveReqtItemProvider = new DeriveReqtItemProvider((AdapterFactory)this);
        }
        return this.deriveReqtItemProvider;
    }

    public Adapter createVerifyAdapter() {
        if (this.verifyItemProvider == null) {
            this.verifyItemProvider = new VerifyItemProvider((AdapterFactory)this);
        }
        return this.verifyItemProvider;
    }

    public Adapter createCopyAdapter() {
        if (this.copyItemProvider == null) {
            this.copyItemProvider = new CopyItemProvider((AdapterFactory)this);
        }
        return this.copyItemProvider;
    }

    public Adapter createSatisfyAdapter() {
        if (this.satisfyItemProvider == null) {
            this.satisfyItemProvider = new SatisfyItemProvider((AdapterFactory)this);
        }
        return this.satisfyItemProvider;
    }

    public Adapter createTestCaseAdapter() {
        if (this.testCaseItemProvider == null) {
            this.testCaseItemProvider = new TestCaseItemProvider((AdapterFactory)this);
        }
        return this.testCaseItemProvider;
    }

    public Adapter createRequirementAdapter() {
        if (this.requirementItemProvider == null) {
            this.requirementItemProvider = new RequirementItemProvider((AdapterFactory)this);
        }
        return this.requirementItemProvider;
    }

    public Adapter createRequirementRelatedAdapter() {
        if (this.requirementRelatedItemProvider == null) {
            this.requirementRelatedItemProvider = new RequirementRelatedItemProvider((AdapterFactory)this);
        }
        return this.requirementRelatedItemProvider;
    }

    public ComposeableAdapterFactory getRootAdapterFactory() {
        return this.parentAdapterFactory == null ? this : this.parentAdapterFactory.getRootAdapterFactory();
    }

    public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
        this.parentAdapterFactory = parentAdapterFactory;
    }

    public boolean isFactoryForType(Object type) {
        return this.supportedTypes.contains(type) || super.isFactoryForType(type);
    }

    public Adapter adapt(Notifier notifier, Object type) {
        return super.adapt(notifier, (Object)this);
    }

    public Object adapt(Object object, Object type) {
        if (this.isFactoryForType(type)) {
            Object adapter = super.adapt(object, type);
            if (!(type instanceof Class) || ((Class)type).isInstance(adapter)) {
                return adapter;
            }
        }
        return null;
    }

    public void addListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.addListener(notifyChangedListener);
    }

    public void removeListener(INotifyChangedListener notifyChangedListener) {
        this.changeNotifier.removeListener(notifyChangedListener);
    }

    public void fireNotifyChanged(Notification notification) {
        this.changeNotifier.fireNotifyChanged(notification);
        if (this.parentAdapterFactory != null) {
            this.parentAdapterFactory.fireNotifyChanged(notification);
        }
    }

    public void dispose() {
        if (this.deriveReqtItemProvider != null) {
            this.deriveReqtItemProvider.dispose();
        }
        if (this.verifyItemProvider != null) {
            this.verifyItemProvider.dispose();
        }
        if (this.copyItemProvider != null) {
            this.copyItemProvider.dispose();
        }
        if (this.satisfyItemProvider != null) {
            this.satisfyItemProvider.dispose();
        }
        if (this.testCaseItemProvider != null) {
            this.testCaseItemProvider.dispose();
        }
        if (this.requirementItemProvider != null) {
            this.requirementItemProvider.dispose();
        }
        if (this.requirementRelatedItemProvider != null) {
            this.requirementRelatedItemProvider.dispose();
        }
    }
}

