/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.requirements.provider;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedImage;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptorDecorator;
import org.eclipse.emf.edit.provider.ItemProviderAdapter;
import org.eclipse.papyrus.sysml.edit.provider.IComposableAdapterFactory;
import org.eclipse.papyrus.sysml.edit.provider.SysMLItemProviderAdapter;
import org.eclipse.papyrus.sysml.provider.SysmlEditPlugin;
import org.eclipse.papyrus.sysml.requirements.RequirementsPackage;
import org.eclipse.papyrus.sysml.requirements.TestCase;
import org.eclipse.papyrus.sysml.util.SysmlResource;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TestCaseItemProvider
extends SysMLItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource {
    private static Pattern TEST_CASE_PREFIX_PATTERN = Pattern.compile("(testCase, |<<testCase>>|, testCase)");
    private static Pattern BEHAVIOR_PREFIX_PATTERN = Pattern.compile("Behavior");
    private static Pattern OPERATION_PREFIX_PATTERN = Pattern.compile("Operation");

    public TestCaseItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (object instanceof TestCase && this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
            this.addBase_BehaviorPropertyDescriptor(object);
            this.addBase_OperationPropertyDescriptor(object);
            this.addVerifiesPropertyDescriptor(object);
        }
        if (object instanceof Behavior) {
            Behavior element = (Behavior)object;
            ArrayList<IItemPropertyDescriptor> itemPropertyDescriptorsForbehavior = new ArrayList<IItemPropertyDescriptor>();
            ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.BEHAVIOR);
            List propertyDescriptors = ite.getPropertyDescriptors((Object)this);
            itemPropertyDescriptorsForbehavior.addAll(propertyDescriptors);
            Stereotype ste = element.getAppliedStereotype(SysmlResource.TEST_CASE_ID);
            if (ste != null) {
                EObject steApplication = element.getStereotypeApplication(ste);
                itemPropertyDescriptorsForbehavior.add((IItemPropertyDescriptor)this.createBase_BehaviorPropertyDescriptorForBehavior(steApplication));
                itemPropertyDescriptorsForbehavior.add((IItemPropertyDescriptor)this.createBase_BehaviorPropertyDescriptorForOperation(steApplication));
                itemPropertyDescriptorsForbehavior.add((IItemPropertyDescriptor)this.createBase_OperationPropertyDescriptorForBehavior(steApplication));
                itemPropertyDescriptorsForbehavior.add((IItemPropertyDescriptor)this.createBase_OperationPropertyDescriptorForOperation(steApplication));
                itemPropertyDescriptorsForbehavior.add((IItemPropertyDescriptor)this.createVerifiesPropertyDescriptorForBehavior(steApplication));
                itemPropertyDescriptorsForbehavior.add((IItemPropertyDescriptor)this.createVerifiesPropertyDescriptorForOperation(steApplication));
            }
            return itemPropertyDescriptorsForbehavior;
        }
        if (object instanceof Operation) {
            Operation element = (Operation)object;
            ArrayList<IItemPropertyDescriptor> itemPropertyDescriptorsForoperation = new ArrayList<IItemPropertyDescriptor>();
            ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.OPERATION);
            List propertyDescriptors = ite.getPropertyDescriptors((Object)this);
            itemPropertyDescriptorsForoperation.addAll(propertyDescriptors);
            Stereotype ste = element.getAppliedStereotype(SysmlResource.TEST_CASE_ID);
            if (ste != null) {
                EObject steApplication = element.getStereotypeApplication(ste);
                itemPropertyDescriptorsForoperation.add((IItemPropertyDescriptor)this.createBase_BehaviorPropertyDescriptorForBehavior(steApplication));
                itemPropertyDescriptorsForoperation.add((IItemPropertyDescriptor)this.createBase_BehaviorPropertyDescriptorForOperation(steApplication));
                itemPropertyDescriptorsForoperation.add((IItemPropertyDescriptor)this.createBase_OperationPropertyDescriptorForBehavior(steApplication));
                itemPropertyDescriptorsForoperation.add((IItemPropertyDescriptor)this.createBase_OperationPropertyDescriptorForOperation(steApplication));
                itemPropertyDescriptorsForoperation.add((IItemPropertyDescriptor)this.createVerifiesPropertyDescriptorForBehavior(steApplication));
                itemPropertyDescriptorsForoperation.add((IItemPropertyDescriptor)this.createVerifiesPropertyDescriptorForOperation(steApplication));
            }
            return itemPropertyDescriptorsForoperation;
        }
        return this.itemPropertyDescriptors;
    }

    protected void addBase_BehaviorPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TestCase_base_Behavior_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TestCase_base_Behavior_feature", "_UI_TestCase_type"), (EStructuralFeature)RequirementsPackage.Literals.TEST_CASE__BASE_BEHAVIOR, true, false, true, null, null, null));
    }

    protected ItemPropertyDescriptorDecorator createBase_BehaviorPropertyDescriptorForBehavior(Object object) {
        return new ItemPropertyDescriptorDecorator(object, (IItemPropertyDescriptor)this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TestCase_base_Behavior_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TestCase_base_Behavior_feature", "_UI_TestCase_type"), (EStructuralFeature)RequirementsPackage.Literals.TEST_CASE__BASE_BEHAVIOR, true, false, true, null, null, null));
    }

    protected ItemPropertyDescriptorDecorator createBase_BehaviorPropertyDescriptorForOperation(Object object) {
        return new ItemPropertyDescriptorDecorator(object, (IItemPropertyDescriptor)this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TestCase_base_Behavior_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TestCase_base_Behavior_feature", "_UI_TestCase_type"), (EStructuralFeature)RequirementsPackage.Literals.TEST_CASE__BASE_BEHAVIOR, true, false, true, null, null, null));
    }

    protected void addBase_OperationPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TestCase_base_Operation_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TestCase_base_Operation_feature", "_UI_TestCase_type"), (EStructuralFeature)RequirementsPackage.Literals.TEST_CASE__BASE_OPERATION, true, false, true, null, null, null));
    }

    protected ItemPropertyDescriptorDecorator createBase_OperationPropertyDescriptorForBehavior(Object object) {
        return new ItemPropertyDescriptorDecorator(object, (IItemPropertyDescriptor)this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TestCase_base_Operation_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TestCase_base_Operation_feature", "_UI_TestCase_type"), (EStructuralFeature)RequirementsPackage.Literals.TEST_CASE__BASE_OPERATION, true, false, true, null, null, null));
    }

    protected ItemPropertyDescriptorDecorator createBase_OperationPropertyDescriptorForOperation(Object object) {
        return new ItemPropertyDescriptorDecorator(object, (IItemPropertyDescriptor)this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TestCase_base_Operation_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TestCase_base_Operation_feature", "_UI_TestCase_type"), (EStructuralFeature)RequirementsPackage.Literals.TEST_CASE__BASE_OPERATION, true, false, true, null, null, null));
    }

    protected void addVerifiesPropertyDescriptor(Object object) {
        this.itemPropertyDescriptors.add(this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TestCase_verifies_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TestCase_verifies_feature", "_UI_TestCase_type"), (EStructuralFeature)RequirementsPackage.Literals.TEST_CASE__VERIFIES, false, false, false, null, null, null));
    }

    protected ItemPropertyDescriptorDecorator createVerifiesPropertyDescriptorForBehavior(Object object) {
        return new ItemPropertyDescriptorDecorator(object, (IItemPropertyDescriptor)this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TestCase_verifies_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TestCase_verifies_feature", "_UI_TestCase_type"), (EStructuralFeature)RequirementsPackage.Literals.TEST_CASE__VERIFIES, false, false, false, null, null, null));
    }

    protected ItemPropertyDescriptorDecorator createVerifiesPropertyDescriptorForOperation(Object object) {
        return new ItemPropertyDescriptorDecorator(object, (IItemPropertyDescriptor)this.createItemPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.getString("_UI_TestCase_verifies_feature"), this.getString("_UI_PropertyDescriptor_description", "_UI_TestCase_verifies_feature", "_UI_TestCase_type"), (EStructuralFeature)RequirementsPackage.Literals.TEST_CASE__VERIFIES, false, false, false, null, null, null));
    }

    public Object getImage(Object object) {
        Object composedImage = this.overlayImage(object, this.getResourceLocator().getImage("full/obj16/TestCase"));
        if (object instanceof NamedElement) {
            ComposedImage aux = new ComposedImage(Collections.singletonList(composedImage));
            return this.composeVisibilityImage(object, aux);
        }
        return composedImage;
    }

    public String getText(Object object) {
        Stereotype ste;
        TestCase testCase_ = null;
        if (object instanceof Behavior && (ste = ((Behavior)object).getAppliedStereotype(SysmlResource.TEST_CASE_ID)) != null) {
            IItemLabelProvider ite = (IItemLabelProvider)((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.BEHAVIOR);
            String result = ite.getText(object);
            result = TEST_CASE_PREFIX_PATTERN.matcher(result).replaceFirst("");
            return BEHAVIOR_PREFIX_PATTERN.matcher(result).replaceFirst("TestCase");
        }
        if (object instanceof Operation && (ste = ((Operation)object).getAppliedStereotype(SysmlResource.TEST_CASE_ID)) != null) {
            IItemLabelProvider ite = (IItemLabelProvider)((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.OPERATION);
            String result = ite.getText(object);
            result = TEST_CASE_PREFIX_PATTERN.matcher(result).replaceFirst("");
            return OPERATION_PREFIX_PATTERN.matcher(result).replaceFirst("TestCase");
        }
        testCase_ = (TestCase)object;
        return this.getString("_UI_TestCase_type");
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        if (((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory() != null) {
            if (notification.getFeatureID(Behavior.class) != -1) {
                ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.BEHAVIOR);
                ite.notifyChanged(notification);
                return;
            }
            if (notification.getFeatureID(Operation.class) != -1) {
                ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.OPERATION);
                ite.notifyChanged(notification);
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
    }

    public ResourceLocator getResourceLocator() {
        return SysmlEditPlugin.INSTANCE;
    }

    public Collection<?> getChildren(Object object) {
        Collection result = super.getChildren(object);
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory() != null) {
                if (UMLPackage.Literals.BEHAVIOR.equals(eObject.eClass())) {
                    ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.BEHAVIOR);
                    result.addAll(ite.getChildren(object));
                    return result;
                }
                if (UMLPackage.Literals.OPERATION.equals(eObject.eClass())) {
                    ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.OPERATION);
                    result.addAll(ite.getChildren(object));
                    return result;
                }
            }
        }
        return result;
    }

    public boolean hasChildren(Object object) {
        if (object instanceof EObject) {
            EObject eObject = (EObject)object;
            if (((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory() != null) {
                if (UMLPackage.Literals.BEHAVIOR.equals(eObject.eClass())) {
                    ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.BEHAVIOR);
                    return super.hasChildren(object) || ite.hasChildren(object);
                }
                if (UMLPackage.Literals.OPERATION.equals(eObject.eClass())) {
                    ItemProviderAdapter ite = ((IComposableAdapterFactory)this.adapterFactory).getIRootAdapterFactory().getItemProvider(UMLPackage.Literals.OPERATION);
                    return super.hasChildren(object) || ite.hasChildren(object);
                }
            }
        }
        return super.hasChildren(object);
    }
}

