/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.service.types.helper;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.papyrus.sysml.blocks.BlocksPackage;
import org.eclipse.papyrus.sysml.util.SysmlResource;
import org.eclipse.papyrus.uml.service.types.helper.advice.AbstractStereotypedElementEditHelperAdvice;
import org.eclipse.papyrus.uml.service.types.utils.NamedElementHelper;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;

public class DimensionEditHelperAdvice
extends AbstractStereotypedElementEditHelperAdvice {
    public DimensionEditHelperAdvice() {
        this.requiredProfileIDs.add(SysmlResource.BLOCKS_ID);
    }

    protected ICommand getBeforeConfigureCommand(final ConfigureRequest request) {
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                NamedElement element = (NamedElement)request.getElementToConfigure();
                if (element != null) {
                    Stereotype stereotypeToApply = element.getApplicableStereotype(SysmlResource.DIMENSION_ID);
                    if (stereotypeToApply != null) {
                        element.applyStereotype(stereotypeToApply);
                    }
                    String initializedName = NamedElementHelper.getDefaultNameWithIncrementFromBase((String)BlocksPackage.eINSTANCE.getDimension().getName(), (Collection)element.eContainer().eContents());
                    element.setName(initializedName);
                }
                return CommandResult.newOKCommandResult((Object)element);
            }
        };
    }
}

