/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.service.types.helper;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.sysml.blocks.Block;
import org.eclipse.papyrus.sysml.blocks.ValueType;
import org.eclipse.papyrus.sysml.portandflows.FlowSpecification;
import org.eclipse.papyrus.sysml.portandflows.PortandflowsPackage;
import org.eclipse.papyrus.sysml.service.types.matcher.BlockMatcher;
import org.eclipse.papyrus.sysml.util.SysmlResource;
import org.eclipse.papyrus.uml.service.types.helper.advice.AbstractStereotypedElementEditHelperAdvice;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;
import org.eclipse.papyrus.uml.service.types.utils.NamedElementHelper;
import org.eclipse.uml2.uml.DataType;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;

public class FlowPortEditHelperAdvice
extends AbstractStereotypedElementEditHelperAdvice {
    public FlowPortEditHelperAdvice() {
        this.requiredProfileIDs.add(SysmlResource.PORT_AND_FLOWS_ID);
    }

    public boolean approveRequest(IEditCommandRequest request) {
        Element contextElement;
        BlockMatcher matcher;
        GetEditContextRequest editContextRequest;
        boolean isApproved = super.approveRequest(request);
        if (request != null && request instanceof GetEditContextRequest && (editContextRequest = (GetEditContextRequest)request).getEditContext() instanceof Element && !(matcher = new BlockMatcher()).matches((EObject)(contextElement = (Element)editContextRequest.getEditContext()))) {
            isApproved = false;
        }
        return isApproved;
    }

    protected ICommand getBeforeConfigureCommand(final ConfigureRequest request) {
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                Port port = (Port)request.getElementToConfigure();
                if (port != null) {
                    Stereotype flowPortStereotype = port.getApplicableStereotype(SysmlResource.FLOW_PORT_ID);
                    if (flowPortStereotype != null) {
                        port.applyStereotype(flowPortStereotype);
                    }
                    String initializedName = NamedElementHelper.getDefaultNameWithIncrementFromBase((String)PortandflowsPackage.eINSTANCE.getFlowPort().getName().toLowerCase(), (Collection)port.eContainer().eContents());
                    port.setName(initializedName);
                }
                return CommandResult.newOKCommandResult((Object)port);
            }
        };
    }

    protected ICommand getBeforeSetCommand(SetRequest request) {
        if (UMLPackage.eINSTANCE.getTypedElement_Type().equals(request.getFeature()) && request.getValue() != null) {
            if (!(request.getValue() instanceof Element)) {
                return UnexecutableCommand.INSTANCE;
            }
            Element value = (Element)request.getValue();
            if (value instanceof DataType || value instanceof Signal) {
                return null;
            }
            ValueType valueType = (ValueType)ElementUtil.getStereotypeApplication((Element)value, ValueType.class);
            Block block = (Block)ElementUtil.getStereotypeApplication((Element)value, Block.class);
            FlowSpecification flowspecification = (FlowSpecification)ElementUtil.getStereotypeApplication((Element)value, FlowSpecification.class);
            if (block != null || valueType != null || flowspecification != null) {
                return null;
            }
            return UnexecutableCommand.INSTANCE;
        }
        return null;
    }
}

