/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.service.types.helper;

import java.util.Arrays;
import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.IElementType;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.GetEditContextRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.papyrus.sysml.portandflows.PortandflowsPackage;
import org.eclipse.papyrus.sysml.service.types.element.SysMLElementTypes;
import org.eclipse.papyrus.sysml.service.types.matcher.FlowSpecificationMatcher;
import org.eclipse.papyrus.sysml.service.types.matcher.RequirementMatcher;
import org.eclipse.papyrus.sysml.util.SysmlResource;
import org.eclipse.papyrus.uml.service.types.element.UMLElementTypes;
import org.eclipse.papyrus.uml.service.types.helper.advice.AbstractStereotypedElementEditHelperAdvice;
import org.eclipse.papyrus.uml.service.types.utils.NamedElementHelper;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;

public class FlowSpecificationEditHelperAdvice
extends AbstractStereotypedElementEditHelperAdvice {
    public FlowSpecificationEditHelperAdvice() {
        this.requiredProfileIDs.add(SysmlResource.PORT_AND_FLOWS_ID);
    }

    protected ICommand getBeforeCreateCommand(CreateElementRequest request) {
        IElementType elementToCreate = request.getElementType();
        if (elementToCreate == UMLElementTypes.OPERATION) {
            return UnexecutableCommand.INSTANCE;
        }
        if (elementToCreate == UMLElementTypes.RECEPTION) {
            return UnexecutableCommand.INSTANCE;
        }
        if (UMLElementTypes.PROPERTY.getEClass().isSuperTypeOf(elementToCreate.getEClass()) && elementToCreate != SysMLElementTypes.FLOW_PROPERTY && !Arrays.asList(elementToCreate.getAllSuperTypes()).contains(SysMLElementTypes.FLOW_PROPERTY)) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getBeforeCreateCommand(request);
    }

    public boolean approveRequest(IEditCommandRequest request) {
        GetEditContextRequest editContextRequest;
        boolean isApproved = super.approveRequest(request);
        if (request != null && request instanceof GetEditContextRequest && (editContextRequest = (GetEditContextRequest)request).getEditContext() instanceof Element) {
            Object matcher = new FlowSpecificationMatcher();
            Element contextElement = (Element)editContextRequest.getEditContext();
            if (matcher.matches((EObject)contextElement)) {
                isApproved = false;
            }
            if ((matcher = new RequirementMatcher()).matches((EObject)contextElement)) {
                isApproved = false;
            }
        }
        return isApproved;
    }

    protected ICommand getBeforeConfigureCommand(final ConfigureRequest request) {
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                NamedElement element = (NamedElement)request.getElementToConfigure();
                if (element != null) {
                    Stereotype stereotypeToApply = element.getApplicableStereotype(SysmlResource.FLOW_SPECIFICATION_ID);
                    if (stereotypeToApply != null) {
                        element.applyStereotype(stereotypeToApply);
                    }
                    String initializedName = NamedElementHelper.getDefaultNameWithIncrementFromBase((String)PortandflowsPackage.eINSTANCE.getFlowSpecification().getName(), (Collection)element.eContainer().eContents());
                    element.setName(initializedName);
                }
                return CommandResult.newOKCommandResult((Object)element);
            }
        };
    }
}

