/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.service.types.helper;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.papyrus.sysml.util.SysmlResource;
import org.eclipse.papyrus.uml.service.types.helper.advice.AbstractStereotypedElementEditHelperAdvice;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;

public class RationaleEditHelperAdvice
extends AbstractStereotypedElementEditHelperAdvice {
    public RationaleEditHelperAdvice() {
        this.requiredProfileIDs.add(SysmlResource.MODEL_ELEMENTS_ID);
    }

    protected ICommand getBeforeConfigureCommand(final ConfigureRequest request) {
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                Stereotype stereotypeToApply;
                Element element = (Element)request.getElementToConfigure();
                if (element != null && (stereotypeToApply = element.getApplicableStereotype(SysmlResource.RATIONALE_ID)) != null) {
                    element.applyStereotype(stereotypeToApply);
                }
                return CommandResult.newOKCommandResult((Object)element);
            }
        };
    }
}

