/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.sysml.service.types.helper.advice;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.papyrus.sysml.service.types.Activator;
import org.eclipse.papyrus.sysml.service.types.helper.advice.AssociationEditHelperAdvice;
import org.eclipse.papyrus.uml.service.types.utils.ClassifierUtils;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.Type;
import org.eclipse.uml2.uml.UMLFactory;

public class AssociationNoneEditHelperAdvice
extends AssociationEditHelperAdvice {
    protected Classifier getSourceOwnerType(ConfigureRequest req) {
        Classifier result = null;
        Object paramObject = req.getParameter("CreateRelationshipRequest.source");
        if (paramObject instanceof Classifier) {
            result = (Classifier)paramObject;
        }
        return result;
    }

    protected Classifier getTargetOwnerType(ConfigureRequest req) {
        Classifier result = null;
        Object paramObject = req.getParameter("CreateRelationshipRequest.target");
        if (paramObject instanceof Classifier) {
            result = (Classifier)paramObject;
        }
        return result;
    }

    protected Property createSourceProperty(Type targetType) {
        Property sourceProperty = UMLFactory.eINSTANCE.createProperty();
        sourceProperty.setLower(1);
        sourceProperty.setUpper(1);
        sourceProperty.setType(targetType);
        sourceProperty.setName(targetType.getName().toLowerCase());
        return sourceProperty;
    }

    protected Property createTargetProperty(Type sourceType) {
        Property targetProperty = UMLFactory.eINSTANCE.createProperty();
        targetProperty.setLower(1);
        targetProperty.setUpper(1);
        targetProperty.setType(sourceType);
        targetProperty.setName(sourceType.getName().toLowerCase());
        return targetProperty;
    }

    protected void addSourceInModel(Property sourceEnd, Classifier owner, Classifier targetType, Association association) throws UnsupportedOperationException {
        boolean added = ClassifierUtils.addOwnedAttribute((Classifier)owner, (Property)sourceEnd);
        if (!added) {
            throw new UnsupportedOperationException("Cannot add a Property on Classifier " + owner.getQualifiedName());
        }
    }

    protected void addTargetInModel(Property targetEnd, Classifier owner, Classifier sourceType, Association association) {
        boolean added = ClassifierUtils.addOwnedAttribute((Classifier)owner, (Property)targetEnd);
        if (!added) {
            throw new UnsupportedOperationException("Cannot add a Property on Classifier " + owner.getQualifiedName());
        }
    }

    protected ICommand getBeforeConfigureCommand(ConfigureRequest request) {
        final Association association = (Association)request.getElementToConfigure();
        final Classifier sourceType = this.getSourceOwnerType(request);
        final Classifier targetType = this.getTargetOwnerType(request);
        if (sourceType == null || targetType == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                Property sourceEnd = AssociationNoneEditHelperAdvice.this.createSourceProperty((Type)targetType);
                Property targetEnd = AssociationNoneEditHelperAdvice.this.createTargetProperty((Type)sourceType);
                association.getMemberEnds().add((Object)sourceEnd);
                association.getMemberEnds().add((Object)targetEnd);
                try {
                    AssociationNoneEditHelperAdvice.this.addSourceInModel(sourceEnd, sourceType, targetType, association);
                    AssociationNoneEditHelperAdvice.this.addTargetInModel(targetEnd, targetType, sourceType, association);
                }
                catch (Exception e) {
                    Activator.log.error((Throwable)e);
                    return CommandResult.newCancelledCommandResult();
                }
                return CommandResult.newOKCommandResult((Object)association);
            }
        };
    }
}

