/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.tabbedproperties.appearance;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ConnectionNodeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.AbstractNotationPropertiesSection;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.appearance.ColorPalettePopup;
import org.eclipse.gmf.runtime.draw2d.ui.figures.FigureUtilities;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.gmf.runtime.notation.datatype.GradientData;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.papyrus.tabbedproperties.appearance.Messages;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.ui.IWorkbenchPart;

public class GradientSection
extends AbstractNotationPropertiesSection {
    private Button policyButton;
    private Composite styleCompo;
    private Spinner transparencyValueSpinner;
    private Button verticalStyle;
    private Button horizontalStyle;
    private Button colorButton;
    private GradientData gradientData = GradientData.getDefaultGradientData();
    private int transparency = -1;
    private boolean isGradientUsed = false;

    public void initializeControls(Composite parent) {
        super.initializeControls(parent);
        GridLayout layout = new GridLayout(2, false);
        Group gradientGroup = this.getWidgetFactory().createGroup(this.composite, Messages.GradientSection_Group_Gradient);
        gradientGroup.setLayout((Layout)layout);
        this.createGradientPolicy((Composite)gradientGroup);
        this.createColorGroup((Composite)gradientGroup);
        this.createStyleGroup((Composite)gradientGroup);
        this.createTransparencyGroup((Composite)gradientGroup);
    }

    protected void createGradientPolicy(Composite parent) {
        this.getWidgetFactory().createCLabel(parent, Messages.GradientSection_Button_ActivateGradient);
        this.policyButton = this.getWidgetFactory().createButton(parent, "", 32);
        this.policyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (!GradientSection.this.policyButton.getSelection()) {
                    GradientSection.this.isGradientUsed = false;
                    GradientSection.this.gradientData = null;
                    GradientSection.this.transparency = 100;
                } else {
                    GradientSection.this.isGradientUsed = true;
                    GradientSection.this.gradientData = new GradientData((GradientData)GradientSection.this.getSingleInput().getPreferredValue((EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_Gradient()));
                    GradientSection.this.transparency = (Integer)GradientSection.this.getSingleInput().getPreferredValue((EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_Transparency());
                }
                GradientSection.this.updateGradient();
                GradientSection.this.updateTransparency();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void createTransparencyGroup(Composite parent) {
        this.getWidgetFactory().createCLabel(parent, Messages.GradientSection_Label_Transparency);
        this.transparencyValueSpinner = new Spinner(parent, 2048);
        this.transparencyValueSpinner.setMinimum(0);
        this.transparencyValueSpinner.setMaximum(100);
        this.transparencyValueSpinner.setIncrement(1);
        this.transparencyValueSpinner.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                GradientSection.this.transparency = GradientSection.this.transparencyValueSpinner.getSelection();
                GradientSection.this.updateTransparency();
            }
        });
    }

    protected void createColorGroup(Composite parent) {
        this.getWidgetFactory().createCLabel(parent, Messages.GradientSection_Label_FirstColor);
        this.colorButton = this.getWidgetFactory().createButton(parent, "", 8);
        this.colorButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                RGB color1 = GradientSection.this.changeColor(GradientSection.this.colorButton);
                if (color1 != null) {
                    GradientSection.this.gradientData.setGradientColor1(FigureUtilities.RGBToInteger((RGB)color1).intValue());
                    GradientSection.this.updateGradient();
                }
            }
        });
    }

    protected void createStyleGroup(Composite parent) {
        this.getWidgetFactory().createCLabel(parent, Messages.GradientSection_Label_Style);
        this.styleCompo = this.getWidgetFactory().createComposite(parent, 0);
        GridLayout layout = new GridLayout(1, true);
        layout.marginWidth = 0;
        this.styleCompo.setLayout((Layout)layout);
        this.verticalStyle = this.getWidgetFactory().createButton(this.styleCompo, Messages.GradientSection_Style_Vertical, 16);
        this.horizontalStyle = this.getWidgetFactory().createButton(this.styleCompo, Messages.GradientSection_Style_Horizontal, 16);
        SelectionAdapter selectionListener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (!((Button)e.widget).getSelection()) {
                    return;
                }
                if (GradientSection.this.verticalStyle.getSelection()) {
                    GradientSection.this.gradientData.setGradientStyle(0);
                } else {
                    GradientSection.this.gradientData.setGradientStyle(1);
                }
                GradientSection.this.updateGradient();
            }
        };
        this.verticalStyle.addSelectionListener((SelectionListener)selectionListener);
        this.horizontalStyle.addSelectionListener((SelectionListener)selectionListener);
    }

    public void dispose() {
        this.disposeButtonImage(this.colorButton);
        super.dispose();
    }

    protected void disposeButtonImage(Button btn) {
        Image imageColor1;
        if (btn != null && !btn.isDisposed() && (imageColor1 = btn.getImage()) != null && !imageColor1.isDisposed()) {
            imageColor1.dispose();
        }
    }

    protected void setButtonImage(Button btn, int intColor) {
        Image image = btn.getImage();
        if (image != null) {
            image.dispose();
        }
        Display display = btn.getParent().getShell().getDisplay();
        RGB rgbColor = FigureUtilities.integerToRGB((Integer)intColor);
        Color color1 = new Color((Device)display, rgbColor);
        image = new Image((Device)display, 16, 16);
        GC gc = new GC((Drawable)image);
        gc.setBackground(color1);
        Rectangle rect = image.getBounds();
        gc.fillRectangle(rect);
        gc.setForeground(display.getSystemColor(2));
        gc.drawRectangle(rect.x, rect.y, rect.width - 1, rect.height - 1);
        gc.dispose();
        color1.dispose();
        btn.setImage(image);
    }

    private RGB changeColor(Button button) {
        ColorPalettePopup popup = new ColorPalettePopup(button.getParent().getShell(), 25);
        Rectangle r = button.getBounds();
        Point location = button.getParent().toDisplay(r.x, r.y);
        popup.open(new Point(location.x, location.y + r.height));
        if (popup.getSelectedColor() == null && !popup.useDefaultColor()) {
            return null;
        }
        return popup.getSelectedColor();
    }

    public void refresh() {
        super.refresh();
        this.refreshComponent();
    }

    protected void refreshComponent() {
        if (this.gradientData != null) {
            if (this.transparency != this.transparencyValueSpinner.getSelection()) {
                this.transparencyValueSpinner.setSelection(this.transparency);
            }
            this.setButtonImage(this.colorButton, this.gradientData.getGradientColor1());
            if (this.horizontalStyle.getSelection() != (this.gradientData.getGradientStyle() == 1)) {
                this.horizontalStyle.setSelection(this.gradientData.getGradientStyle() == 1);
            }
            if (this.verticalStyle.getSelection() != (this.gradientData.getGradientStyle() == 0)) {
                this.verticalStyle.setSelection(this.gradientData.getGradientStyle() == 0);
            }
        }
        this.policyButton.setSelection(this.isGradientUsed);
        this.styleCompo.setEnabled(this.isGradientUsed);
        this.transparencyValueSpinner.setEnabled(this.isGradientUsed);
        this.verticalStyle.setEnabled(this.isGradientUsed);
        this.horizontalStyle.setEnabled(this.isGradientUsed);
        this.colorButton.setEnabled(this.isGradientUsed);
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.executeAsReadAction(new Runnable(){

            public void run() {
                IGraphicalEditPart ep = GradientSection.this.getSingleInput();
                if (ep != null) {
                    GradientSection.this.gradientData = new GradientData((GradientData)GradientSection.this.getSingleInput().getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_Gradient()));
                    GradientSection.this.transparency = (Integer)GradientSection.this.getSingleInput().getStructuralFeatureValue((EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_Transparency());
                }
            }
        });
        this.isGradientUsed = !this.gradientData.equals((Object)GradientData.getDefaultGradientData());
    }

    protected void updateFeature(final EStructuralFeature feature, final Object value, String commandName) {
        List inputs = this.getInput();
        ArrayList<ICommand> commands = new ArrayList<ICommand>();
        for (Object input : inputs) {
            if (!(input instanceof IGraphicalEditPart)) continue;
            final IGraphicalEditPart gep = (IGraphicalEditPart)input;
            if (input instanceof ConnectionNodeEditPart) continue;
            commands.add(this.createCommand(commandName, ((View)gep.getModel()).eResource(), new Runnable(){

                public void run() {
                    gep.setStructuralFeatureValue(feature, value);
                }
            }));
        }
        this.executeAsCompositeCommand(commandName, commands);
    }

    protected void updateTransparency() {
        this.updateFeature((EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_Transparency(), new Integer(this.transparency), "Change Transparency command");
    }

    protected void updateGradient() {
        GradientData value = null;
        if (this.gradientData != null) {
            value = new GradientData(this.gradientData);
        }
        this.updateFeature((EStructuralFeature)NotationPackage.eINSTANCE.getFillStyle_Gradient(), value, "Change Gradient command");
    }
}

