/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.tabbedproperties.appearance;

import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.properties.sections.AbstractNotationPropertiesSection;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.papyrus.diagram.common.editpolicies.IMaskManagedLabelEditPolicy;
import org.eclipse.papyrus.tabbedproperties.appearance.Activator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.dialogs.PreferencesUtil;

public class MaskManagedLabelSection
extends AbstractNotationPropertiesSection {
    protected IMaskManagedLabelEditPolicy editPolicy;
    protected IGraphicalEditPart editPart;
    protected Table table;

    public void initializeControls(Composite parent) {
        super.initializeControls(parent);
        GridLayout layout = new GridLayout(2, false);
        Group gradientGroup = this.getWidgetFactory().createGroup(this.composite, "Label Customization");
        gradientGroup.setLayout((Layout)layout);
        Composite maskPolicyCompo = this.getWidgetFactory().createComposite((Composite)gradientGroup, 0);
        maskPolicyCompo.setLayout((Layout)new GridLayout(2, false));
        GridData gd = new GridData(4, 4, true, true);
        maskPolicyCompo.setLayoutData((Object)gd);
        this.table = this.getWidgetFactory().createTable(maskPolicyCompo, 32);
        gd = new GridData(4, 0x1000000, true, true);
        this.table.setData((Object)gd);
        this.table.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                if (e.detail != 32) {
                    return;
                }
                Object source = e.getSource();
                Widget item = e.item;
                if (source instanceof Table && item instanceof TableItem) {
                    int maskValue = (Integer)((TableItem)item).getData();
                    MaskManagedLabelSection.this.applyMask(maskValue, ((TableItem)item).getChecked());
                }
                MaskManagedLabelSection.this.refresh();
            }
        });
        TableColumn column = new TableColumn(this.table, 0x1000000);
        column.setWidth(120);
        Composite buttonComposite = this.getWidgetFactory().createComposite(maskPolicyCompo, 0);
        buttonComposite.setLayout((Layout)new GridLayout(1, false));
        gd = new GridData(4, 4, false, true);
        buttonComposite.setLayoutData((Object)gd);
        Button setDefaultButton = this.getWidgetFactory().createButton(buttonComposite, "Set Default", 0);
        setDefaultButton.setLayoutData((Object)new GridData(4, 4, true, false));
        setDefaultButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                MaskManagedLabelSection.this.editPolicy.setDefaultDisplayValue();
                MaskManagedLabelSection.this.refresh();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Button viewPrefButton = this.getWidgetFactory().createButton(buttonComposite, "View Preferences", 0);
        viewPrefButton.setLayoutData((Object)new GridData(4, 4, true, false));
        viewPrefButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                PreferenceDialog dialog = PreferencesUtil.createPreferenceDialogOn((Shell)MaskManagedLabelSection.this.getPart().getSite().getShell(), (String)MaskManagedLabelSection.this.editPolicy.getPreferencePageID(), null, null);
                dialog.open();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    protected void applyMask(int maskValue, boolean checked) {
        int newValue = this.getMaskManagedLabelEditPolicy(this.editPart).getCurrentDisplayValue();
        newValue = checked ? (newValue |= maskValue) : (newValue &= ~maskValue);
        this.editPolicy.updateDisplayValue(newValue);
    }

    public void dispose() {
        super.dispose();
    }

    public void refresh() {
        super.refresh();
        this.refreshTable();
    }

    protected void refreshTable() {
        int displayValue = this.editPolicy.getCurrentDisplayValue();
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item;
            int maskValue = (Integer)(item = tableItemArray[n2]).getData();
            item.setChecked((displayValue & maskValue) == maskValue);
            ++n2;
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        this.executeAsReadAction(new Runnable(){

            public void run() {
                MaskManagedLabelSection.this.editPart = MaskManagedLabelSection.this.getSingleInput();
                if (MaskManagedLabelSection.this.editPart != null) {
                    MaskManagedLabelSection.this.editPolicy = MaskManagedLabelSection.this.getMaskManagedLabelEditPolicy(MaskManagedLabelSection.this.editPart);
                    if (MaskManagedLabelSection.this.editPolicy == null) {
                        Activator.getDefault().getLog().log((IStatus)new Status(2, "org.eclipse.papyrus.tabbedproperties.appearance", "Trying to display the mask managed Section with an element that does not have the correct edit policy: " + MaskManagedLabelSection.this.editPart));
                    } else {
                        MaskManagedLabelSection.this.manageTableItems();
                    }
                }
            }
        });
    }

    protected void manageTableItems() {
        TableItem[] tableItemArray = this.table.getItems();
        int n = tableItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            TableItem item = tableItemArray[n2];
            item.dispose();
            ++n2;
        }
        this.createItems();
    }

    protected void createItems() {
        Map masks = this.editPolicy.getMasks();
        Iterator iterator = masks.keySet().iterator();
        while (iterator.hasNext()) {
            int maskValue = (Integer)iterator.next();
            TableItem item = new TableItem(this.table, 0);
            item.setText((String)masks.get(maskValue));
            item.setData((Object)maskValue);
        }
    }

    private IMaskManagedLabelEditPolicy getMaskManagedLabelEditPolicy(IGraphicalEditPart ep) {
        return (IMaskManagedLabelEditPolicy)ep.getEditPolicy((Object)"MaskManagedLabelPolicy");
    }
}

