/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.tabbedproperties.appearance;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.umlutils.NamedElementUtil;
import org.eclipse.papyrus.umlutils.ui.command.SetQualifiedNameDepthCommand;
import org.eclipse.papyrus.umlutils.ui.helper.QualifiedNameHelper;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;

public class QualifiedNameAppearanceSection
extends AbstractPropertySection {
    private CLabel qualifiedNameAppearance;
    private CCombo comboQualifiedNameAppearance;
    private SelectionListener comboQualifiedNameAppearanceListener;
    private GraphicalEditPart namedElementEditPart;
    private IMultiDiagramEditor editor;
    private TransactionalEditingDomain editingDomain;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.qualifiedNameAppearance = this.getWidgetFactory().createCLabel(composite, "Qualified Name Depth:");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.top = new FormAttachment((Control)this.qualifiedNameAppearance, 1, 0x1000000);
        this.qualifiedNameAppearance.setLayoutData((Object)data);
        this.comboQualifiedNameAppearance = this.getWidgetFactory().createCCombo(composite, 2048);
        this.comboQualifiedNameAppearance.add("Full");
        data = new FormData();
        data.left = new FormAttachment((Control)this.qualifiedNameAppearance, 0);
        data.top = new FormAttachment(0, 0);
        this.comboQualifiedNameAppearance.setLayoutData((Object)data);
        this.comboQualifiedNameAppearanceListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                QualifiedNameAppearanceSection.this.updateSelectedElements();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.comboQualifiedNameAppearance.addSelectionListener(this.comboQualifiedNameAppearanceListener);
    }

    public int getQualifiedNamedepth(View view) {
        String depthString;
        EMap entries;
        EAnnotation stereotypeDisplayKind = view.getEAnnotation("QualifiedName");
        if (stereotypeDisplayKind != null && (entries = stereotypeDisplayKind.getDetails()) != null && (depthString = (String)entries.get((Object)"QualifiedNameDepth")) != null) {
            Integer i = new Integer(depthString);
            return i;
        }
        return 0;
    }

    public void refresh() {
        if (!this.comboQualifiedNameAppearance.isDisposed()) {
            this.comboQualifiedNameAppearance.removeSelectionListener(this.comboQualifiedNameAppearanceListener);
            if (this.namedElementEditPart != null && this.namedElementEditPart.getModel() != null && ((View)this.namedElementEditPart.getModel()).getElement() != null) {
                Element element = (Element)((View)this.namedElementEditPart.getModel()).getElement();
                if (element instanceof NamedElement) {
                    this.comboQualifiedNameAppearance.setEnabled(true);
                    this.comboQualifiedNameAppearance.removeAll();
                    int depth = NamedElementUtil.getQualifiedNameMaxDepth((NamedElement)((NamedElement)element));
                    if (depth != 0) {
                        this.comboQualifiedNameAppearance.add("Full");
                        int i = 1;
                        while (i < depth) {
                            this.comboQualifiedNameAppearance.add("-" + i);
                            ++i;
                        }
                        this.comboQualifiedNameAppearance.add("None");
                    } else {
                        this.comboQualifiedNameAppearance.add("None");
                    }
                    int qualifiedNameDepth = QualifiedNameHelper.getQualifiedNameDepth((EModelElement)((EModelElement)this.namedElementEditPart.getModel()));
                    if (depth != 0) {
                        if (qualifiedNameDepth == 0) {
                            this.comboQualifiedNameAppearance.setText("Full");
                        } else if (qualifiedNameDepth >= depth) {
                            this.comboQualifiedNameAppearance.setText("None");
                        } else {
                            this.comboQualifiedNameAppearance.setText("-" + qualifiedNameDepth);
                        }
                    } else {
                        this.comboQualifiedNameAppearance.setText("None");
                    }
                } else {
                    this.comboQualifiedNameAppearance.setEnabled(false);
                    this.comboQualifiedNameAppearance.setText("None");
                }
            }
            this.comboQualifiedNameAppearance.addSelectionListener(this.comboQualifiedNameAppearanceListener);
        }
    }

    public void dispose() {
        super.dispose();
        if (this.comboQualifiedNameAppearance != null && !this.comboQualifiedNameAppearance.isDisposed()) {
            this.comboQualifiedNameAppearance.removeSelectionListener(this.comboQualifiedNameAppearanceListener);
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        IContributedContentsView contributedView;
        super.setInput(part, selection);
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof GraphicalEditPart) {
            this.namedElementEditPart = (GraphicalEditPart)input;
        }
        if (part instanceof ContentOutline && (contributedView = (IContributedContentsView)((ContentOutline)part).getAdapter(IContributedContentsView.class)) != null) {
            part = contributedView.getContributingPart();
        }
        if (part instanceof IMultiDiagramEditor) {
            this.editor = (IMultiDiagramEditor)part;
            this.editingDomain = this.getTransactionalEditingDomain(this.editor);
        } else {
            this.editingDomain = null;
        }
    }

    private TransactionalEditingDomain getTransactionalEditingDomain(IMultiDiagramEditor editor) {
        try {
            return (TransactionalEditingDomain)editor.getServicesRegistry().getService(TransactionalEditingDomain.class);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void updateSelectedElements() {
        if (!(this.getSelection() instanceof IStructuredSelection)) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)this.getSelection();
        CompoundCommand cc = new CompoundCommand();
        List selectedElements = selection.toList();
        for (Object element : selectedElements) {
            String currentQualifiedNameSpec;
            if (!(element instanceof GraphicalEditPart)) continue;
            GraphicalEditPart namedElementEditPart = (GraphicalEditPart)element;
            String currentQualifiedNameDepth = this.comboQualifiedNameAppearance.getText();
            if ("Full".equals(currentQualifiedNameDepth)) {
                currentQualifiedNameSpec = "0";
            } else if ("None".equals(currentQualifiedNameDepth)) {
                NamedElement ne = (NamedElement)((View)namedElementEditPart.getModel()).getElement();
                currentQualifiedNameSpec = "" + NamedElementUtil.getQualifiedNameMaxDepth((NamedElement)ne);
            } else {
                currentQualifiedNameSpec = currentQualifiedNameDepth.substring(1);
            }
            int qualifiedNameDepth = Integer.parseInt(currentQualifiedNameSpec);
            cc.append((Command)new SetQualifiedNameDepthCommand(this.editingDomain, (EModelElement)namedElementEditPart.getModel(), qualifiedNameDepth));
        }
        if (this.editingDomain != null) {
            this.editingDomain.getCommandStack().execute(cc.unwrap());
        }
        this.refresh();
    }
}

