/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.tabbedproperties.appearance;

import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.core.editor.IMultiDiagramEditor;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.umlutils.ui.command.SetShadowFigureCommand;
import org.eclipse.papyrus.umlutils.ui.helper.ShadowFigureHelper;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.IContributedContentsView;
import org.eclipse.ui.views.contentoutline.ContentOutline;
import org.eclipse.ui.views.properties.tabbed.AbstractPropertySection;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ShadowAppearanceSection
extends AbstractPropertySection {
    private CLabel shadowLabel;
    private Button checboxShadowAppearence;
    private SelectionListener cheboxShadowAppearanceListener;
    private GraphicalEditPart editPart;
    private IMultiDiagramEditor editor;
    private TransactionalEditingDomain editingDomain;

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createFlatFormComposite(parent);
        this.shadowLabel = this.getWidgetFactory().createCLabel(composite, "Shadow :");
        FormData data = new FormData();
        data.left = new FormAttachment(0, 0);
        this.shadowLabel.setLayoutData((Object)data);
        this.checboxShadowAppearence = this.getWidgetFactory().createButton(composite, "", 32);
        data = new FormData();
        data.left = new FormAttachment((Control)this.shadowLabel, 0);
        data.top = new FormAttachment((Control)this.shadowLabel, 1, 0x1000000);
        this.checboxShadowAppearence.setLayoutData((Object)data);
        this.cheboxShadowAppearanceListener = new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ShadowAppearanceSection.this.editPart != null && (View)ShadowAppearanceSection.this.editPart.getModel() != null) {
                    Boolean isChecked = ShadowAppearanceSection.this.checboxShadowAppearence.getSelection();
                    if (ShadowAppearanceSection.this.editingDomain != null) {
                        ShadowAppearanceSection.this.editingDomain.getCommandStack().execute((Command)new SetShadowFigureCommand(ShadowAppearanceSection.this.editingDomain, (EModelElement)ShadowAppearanceSection.this.editPart.getModel(), isChecked.booleanValue()));
                    }
                    ShadowAppearanceSection.this.refresh();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        };
        this.checboxShadowAppearence.addSelectionListener(this.cheboxShadowAppearanceListener);
    }

    public void refresh() {
        if (!this.checboxShadowAppearence.isDisposed()) {
            this.checboxShadowAppearence.removeSelectionListener(this.cheboxShadowAppearanceListener);
            if (this.editPart != null) {
                if (this.editPart.getModel() != null) {
                    this.checboxShadowAppearence.setSelection(ShadowFigureHelper.getShadowFigureValue((EModelElement)((EModelElement)this.editPart.getModel())));
                } else {
                    this.checboxShadowAppearence.setEnabled(false);
                }
            }
        }
        this.checboxShadowAppearence.addSelectionListener(this.cheboxShadowAppearanceListener);
    }

    public void dispose() {
        super.dispose();
        if (this.checboxShadowAppearence != null && !this.checboxShadowAppearence.isDisposed()) {
            this.checboxShadowAppearence.removeSelectionListener(this.cheboxShadowAppearanceListener);
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        IContributedContentsView contributedView;
        super.setInput(part, selection);
        Object input = ((IStructuredSelection)selection).getFirstElement();
        if (input instanceof GraphicalEditPart) {
            this.editPart = (GraphicalEditPart)input;
        }
        if (part instanceof ContentOutline && (contributedView = (IContributedContentsView)((ContentOutline)part).getAdapter(IContributedContentsView.class)) != null) {
            part = contributedView.getContributingPart();
        }
        if (part instanceof IMultiDiagramEditor) {
            this.editor = (IMultiDiagramEditor)part;
            this.editingDomain = this.getTransactionalEditingDomain(this.editor);
        } else {
            this.editingDomain = null;
        }
    }

    private TransactionalEditingDomain getTransactionalEditingDomain(IMultiDiagramEditor editor) {
        try {
            return (TransactionalEditingDomain)editor.getServicesRegistry().getService(TransactionalEditingDomain.class);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return null;
        }
    }
}

