/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.tabbedproperties.core.providers;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.graphics.Image;

public class EMFObjectLabelProvider
extends AdapterFactoryLabelProvider
implements ILabelProvider {
    private static final Class<?> IItemLabelProviderClass = IItemLabelProvider.class;
    private static Map<String, AdapterFactory> factories = new HashMap<String, AdapterFactory>();
    private static final String EXT_FACTORIES = "org.eclipse.emf.edit.itemProviderAdapterFactories";

    public EMFObjectLabelProvider() {
        super((AdapterFactory)new ReflectiveItemProviderAdapterFactory());
    }

    public String getText(Object element) {
        String title = "";
        EObject eObject = this.getModel(element);
        IItemLabelProvider itemLabelProvider = this.getItemLabelProvider(eObject);
        if (itemLabelProvider != null) {
            title = itemLabelProvider.getText((Object)eObject);
        }
        if ("".equals(title)) {
            title = super.getText((Object)eObject);
        }
        return title;
    }

    public Image getImage(Object element) {
        Image result = null;
        EObject eObject = this.getModel(element);
        IItemLabelProvider itemLabelProvider = this.getItemLabelProvider(eObject);
        if (itemLabelProvider != null) {
            result = this.getImageFromObject(itemLabelProvider.getImage((Object)eObject));
        }
        return result;
    }

    private EObject getModel(Object element) {
        EObject eObject = null;
        if (element != null && element instanceof StructuredSelection) {
            StructuredSelection selection = (StructuredSelection)element;
            Object o = selection.getFirstElement();
            eObject = this.resolveSemanticObject(o);
            if (o instanceof IGraphicalEditPart) {
                IGraphicalEditPart editPart = (IGraphicalEditPart)o;
                eObject = editPart.resolveSemanticElement();
            }
        }
        return eObject;
    }

    private EObject resolveSemanticObject(Object object) {
        IAdaptable adaptable;
        if (object instanceof EObject) {
            return (EObject)object;
        }
        if (object instanceof IAdaptable && (adaptable = (IAdaptable)object).getAdapter(EObject.class) != null) {
            return (EObject)adaptable.getAdapter(EObject.class);
        }
        return null;
    }

    private IItemLabelProvider getItemLabelProvider(EObject eObject) {
        AdapterFactory adapterFactory;
        IItemLabelProvider itemLabelProvider = null;
        if (eObject != null && (adapterFactory = EMFObjectLabelProvider.getEditFactory(eObject)) != null) {
            return (IItemLabelProvider)adapterFactory.adapt((Notifier)eObject, IItemLabelProviderClass);
        }
        return itemLabelProvider;
    }

    public static AdapterFactory getEditFactory(EObject eobject) {
        String uri = eobject.eClass().getEPackage().getNsURI();
        return EMFObjectLabelProvider.getFactory(uri);
    }

    public static AdapterFactory getFactory(String uri) {
        AdapterFactory factory = factories.get(uri);
        if (factory == null) {
            IConfigurationElement[] extensions;
            IConfigurationElement[] iConfigurationElementArray = extensions = Platform.getExtensionRegistry().getConfigurationElementsFor(EXT_FACTORIES);
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement e = iConfigurationElementArray[n2];
                if (uri.equals(e.getAttribute("uri"))) {
                    try {
                        factory = (AdapterFactory)e.createExecutableExtension("class");
                        if (factory != null) {
                            factories.put(uri, factory);
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
                ++n2;
            }
        }
        return factory;
    }
}

