/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.table.common.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.facet.infra.query.ModelQuery;
import org.eclipse.emf.facet.infra.query.core.AbstractModelQuery;
import org.eclipse.emf.facet.infra.query.core.ModelQuerySetCatalog;
import org.eclipse.emf.facet.infra.query.core.exception.ModelQueryException;
import org.eclipse.emf.facet.infra.query.runtime.ModelQueryResult;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidgetProvider;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.Column;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.DefaultLabelColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.EContainerColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance.MetaClassColumn;
import org.eclipse.emf.facet.widgets.nattable.instance.tableinstance2.TableInstance2;
import org.eclipse.emf.facet.widgets.nattable.internal.NatTableWidgetInternalUtils;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.TriggerListener;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.services.ServicesRegistry;
import org.eclipse.papyrus.core.utils.ServiceUtils;
import org.eclipse.papyrus.table.common.Activator;
import org.eclipse.papyrus.table.common.internal.IPapyrusNatTableWidget;
import org.eclipse.papyrus.table.common.internal.NatTableEditor;
import org.eclipse.papyrus.table.common.internal.TableEditorInput;
import org.eclipse.papyrus.table.common.listener.ModelTriggerListener;
import org.eclipse.papyrus.table.common.listener.TableTriggerListener;
import org.eclipse.papyrus.table.common.messages.Messages;
import org.eclipse.papyrus.table.instance.papyrustableinstance.PapyrusTableInstance;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractNattableEditor
extends NatTableEditor {
    protected ServicesRegistry servicesRegistry;
    protected PapyrusTableInstance rawModel;
    private TriggerListener modelTriggerListener;
    private TriggerListener tableTriggerListener;
    private final PartNameSynchronizer synchronizer;

    public AbstractNattableEditor(ServicesRegistry servicesRegistry, PapyrusTableInstance rawModel) {
        this.servicesRegistry = servicesRegistry;
        this.rawModel = rawModel;
        this.synchronizer = new PartNameSynchronizer(rawModel);
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        TableEditorInput tableEditorInput = new TableEditorInput(this.rawModel, this.getEditingDomain());
        this.initHiddenColumn(this.rawModel);
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(tableEditorInput);
        this.setPartName(this.rawModel.getName());
        this.addListeners();
        super.init(site, tableEditorInput);
    }

    protected void addListeners() {
        EditingDomain editingDomain = this.getEditingDomain();
        Assert.isTrue((boolean)(editingDomain instanceof TransactionalEditingDomain));
        this.modelTriggerListener = new ModelTriggerListener(this.rawModel, (INatTableWidgetProvider)this.getAdapter(INatTableWidgetProvider.class));
        ((TransactionalEditingDomain)editingDomain).addResourceSetListener((ResourceSetListener)this.modelTriggerListener);
        this.tableTriggerListener = new TableTriggerListener(this.rawModel, (INatTableWidgetProvider)this.getAdapter(INatTableWidgetProvider.class));
        ((TransactionalEditingDomain)editingDomain).addResourceSetListener((ResourceSetListener)this.tableTriggerListener);
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.rawModel.isIsSynchronized()) {
            ENotificationImpl impl = new ENotificationImpl((InternalEObject)this.rawModel, 11, null, null, null);
            List<ENotificationImpl> notifications = Collections.singletonList(impl);
            ResourceSetChangeEvent event = new ResourceSetChangeEvent((TransactionalEditingDomain)this.getEditingDomain(), null, notifications);
            Command cmd = null;
            try {
                cmd = this.modelTriggerListener.transactionAboutToCommit(event);
                if (cmd != null && cmd.canExecute()) {
                    cmd.execute();
                }
            }
            catch (Exception e) {
                Activator.helper.error(Messages.AbstractNattableEditor_ICantUpdateTheOpenedTable, (Throwable)e);
            }
        }
    }

    @Override
    public void dispose() {
        ((TransactionalEditingDomain)this.getEditingDomain()).removeResourceSetListener((ResourceSetListener)this.modelTriggerListener);
        ((TransactionalEditingDomain)this.getEditingDomain()).removeResourceSetListener((ResourceSetListener)this.tableTriggerListener);
        super.dispose();
    }

    private void initHiddenColumn(PapyrusTableInstance rawModel2) {
        for (Column current : rawModel2.getTable().getColumns()) {
            if (!(current instanceof DefaultLabelColumn) && !(current instanceof MetaClassColumn) && !(current instanceof EContainerColumn)) continue;
            String name = NatTableWidgetInternalUtils.getColumnName((Column)current);
            if (!this.getInitialHiddenColumns().contains(name)) continue;
            current.setIsHidden(true);
        }
    }

    protected List<String> getInitialHiddenColumns() {
        return Collections.emptyList();
    }

    @Override
    public EditingDomain getEditingDomain() {
        try {
            return ServiceUtils.getInstance().getTransactionalEditingDomain((Object)this.servicesRegistry);
        }
        catch (ServiceException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Deprecated
    protected void executeQueries() {
        if (this.rawModel.isIsSynchronized()) {
            TableInstance2 table = this.rawModel.getTable();
            EObject context = table.getContext();
            ArrayList<EObject> elementsToAdd = new ArrayList<EObject>();
            for (ModelQuery query : this.rawModel.getFillingQueries()) {
                ModelQueryResult result;
                Object value;
                ModelQuerySetCatalog catalog = ModelQuerySetCatalog.getSingleton();
                AbstractModelQuery impl = null;
                try {
                    impl = catalog.getModelQueryImpl(query);
                }
                catch (ModelQueryException e) {
                    e.printStackTrace();
                }
                if (impl == null || !((value = (result = impl.evaluate(context)).getValue()) instanceof Collection)) continue;
                for (Object currentObject : (Collection)value) {
                    if (!(currentObject instanceof EObject) || table.getElements().contains(currentObject)) continue;
                    elementsToAdd.add((EObject)currentObject);
                }
            }
            if (!elementsToAdd.isEmpty() && this.natTableWidget instanceof IPapyrusNatTableWidget) {
                ((IPapyrusNatTableWidget)this.natTableWidget).addRowsOutOfCommandStack(elementsToAdd);
            }
        }
    }

    public class PartNameSynchronizer {
        private PapyrusTableInstance papyrusTable;
        private final Adapter tableNameListener = new Adapter(){

            public void notifyChanged(Notification notification) {
                if (notification.getFeatureID(PapyrusTableInstance.class) == 0 && notification.getNotifier() == PartNameSynchronizer.this.papyrusTable) {
                    AbstractNattableEditor.this.setPartName(PartNameSynchronizer.this.papyrusTable.getName());
                }
            }

            public Notifier getTarget() {
                return null;
            }

            public void setTarget(Notifier newTarget) {
            }

            public boolean isAdapterForType(Object type) {
                return false;
            }
        };

        public PartNameSynchronizer(PapyrusTableInstance papyrusTable) {
            this.setTable(papyrusTable);
        }

        public void setTable(PapyrusTableInstance papyrusTable) {
            if (this.papyrusTable != null) {
                papyrusTable.eAdapters().remove((Object)this.tableNameListener);
            }
            this.papyrusTable = papyrusTable;
            AbstractNattableEditor.this.setPartName(papyrusTable.getName());
            papyrusTable.eAdapters().add((Object)this.tableNameListener);
        }
    }
}

