/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.table.menu.handler;

import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidget;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidgetProvider;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.InstantiationMethod;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.table.menu.handler.AbstractTableExtensionContributionFactory;
import org.eclipse.papyrus.table.menu.messages.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.services.IServiceLocator;

public class CreateNewElementInPopupContributionItem
extends AbstractTableExtensionContributionFactory {
    public void createContributionItems(IServiceLocator serviceLocator, IContributionRoot additions) {
        super.createContributionItems(serviceLocator, additions);
        INatTableWidgetProvider provider = this.getINatTableWidgetProvider();
        if (provider != null) {
            final INatTableWidget natTableWidget = provider.getNatTableWidget();
            MenuManager manager = new MenuManager(Messages.CreateMenuForNewElementInPopupContributionItem_CreateNewElementMenu){

                public void fill(Menu parent, int index) {
                    super.fill(parent, index);
                    this.getMenu().getParentItem().setEnabled(natTableWidget.getInstantionMethodHistory().size() != 0);
                    Image image = Activator.getImage((String)"IMG_OBJ_ADD");
                    this.getMenu().getParentItem().setImage(image);
                }
            };
            manager.setVisible(true);
            ContributionItem item = new ContributionItem(){

                public void fill(final Menu menu, int index) {
                    int i = 0;
                    while (i < natTableWidget.getInstantionMethodHistory().size()) {
                        final InstantiationMethod meth = (InstantiationMethod)natTableWidget.getInstantionMethodHistory().get(i);
                        MenuItem menuItem = new MenuItem(menu, 32);
                        menuItem.setText(String.valueOf(i) + " " + meth.getName());
                        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                MenuItem[] menuItemArray = menu.getItems();
                                int n = menuItemArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    MenuItem menuItem2 = menuItemArray[n2];
                                    menuItem2.setSelection(false);
                                    ++n2;
                                }
                                MenuItem localMenuItem = (MenuItem)e.widget;
                                localMenuItem.setSelection(true);
                                natTableWidget.createNewElement(meth);
                            }
                        });
                        ++i;
                    }
                    boolean enabled = menu.getItemCount() != 0;
                    menu.setEnabled(enabled);
                }
            };
            Menu menu = manager.getMenu();
            if (menu != null) {
                menu.setEnabled(false);
            }
            manager.add((IContributionItem)item);
            Expression visibleWhen = new Expression(){

                public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
                    return EvaluationResult.TRUE;
                }
            };
            additions.addContributionItem((IContributionItem)manager, visibleWhen);
        }
    }
}

