/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.table.menu.handler;

import java.util.List;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidget;
import org.eclipse.emf.facet.widgets.nattable.INatTableWidgetProvider;
import org.eclipse.emf.facet.widgets.nattable.tableconfiguration.InstantiationMethod;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.papyrus.diagram.common.Activator;
import org.eclipse.papyrus.table.menu.handler.AbstractTableExtensionContributionFactory;
import org.eclipse.papyrus.table.menu.messages.Messages;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.ISelectionService;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.menus.IContributionRoot;
import org.eclipse.ui.services.IServiceLocator;

public class CreateNewElementInTableMenuContributionItem
extends AbstractTableExtensionContributionFactory {
    private ISelectionListener listener = null;

    public void createContributionItems(final IServiceLocator serviceLocator, IContributionRoot additions) {
        super.createContributionItems(serviceLocator, additions);
        MenuManager manager = new MenuManager(Messages.CreateMenuForNewElementInPopupContributionItem_CreateNewElementMenu){

            public void fill(Menu parent, int index) {
                super.fill(parent, index);
                Image image = Activator.getImage((String)"IMG_OBJ_ADD");
                this.getMenu().getParentItem().setImage(image);
                INatTableWidgetProvider provider = CreateNewElementInTableMenuContributionItem.this.getINatTableWidgetProvider();
                if (provider != null) {
                    List methods = provider.getNatTableWidget().getInstantionMethodHistory();
                    this.getMenu().getParentItem().setEnabled(methods.size() != 0);
                }
            }

            public void dispose() {
                if (CreateNewElementInTableMenuContributionItem.this.listener != null) {
                    ISelectionService selectionService = (ISelectionService)serviceLocator.getService(ISelectionService.class);
                    selectionService.removeSelectionListener(CreateNewElementInTableMenuContributionItem.this.listener);
                }
                super.dispose();
            }

            public boolean isDynamic() {
                return true;
            }
        };
        ContributionItem item = new ContributionItem(){

            public void fill(final Menu menu, int index) {
                INatTableWidgetProvider provider = CreateNewElementInTableMenuContributionItem.this.getINatTableWidgetProvider();
                if (provider != null) {
                    final INatTableWidget natTableWidget = provider.getNatTableWidget();
                    int i = 0;
                    while (i < natTableWidget.getInstantionMethodHistory().size()) {
                        final InstantiationMethod meth = (InstantiationMethod)natTableWidget.getInstantionMethodHistory().get(i);
                        MenuItem menuItem = new MenuItem(menu, 32);
                        menuItem.setText(String.valueOf(i) + " " + meth.getName());
                        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                MenuItem[] menuItemArray = menu.getItems();
                                int n = menuItemArray.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    MenuItem menuItem2 = menuItemArray[n2];
                                    menuItem2.setSelection(false);
                                    ++n2;
                                }
                                MenuItem localMenuItem = (MenuItem)e.widget;
                                localMenuItem.setSelection(true);
                                natTableWidget.createNewElement(meth);
                            }
                        });
                        ++i;
                    }
                    boolean enabled = menu.getItemCount() != 0;
                    menu.setEnabled(enabled);
                }
            }

            public boolean isDynamic() {
                return true;
            }
        };
        manager.add((IContributionItem)item);
        Expression visibleWhen = new Expression(){

            public EvaluationResult evaluate(IEvaluationContext context) throws CoreException {
                INatTableWidgetProvider provider = CreateNewElementInTableMenuContributionItem.this.getINatTableWidgetProvider();
                if (provider != null) {
                    return EvaluationResult.TRUE;
                }
                return EvaluationResult.FALSE;
            }
        };
        additions.addContributionItem((IContributionItem)manager, visibleWhen);
        this.addSelectionListener(manager);
    }

    protected void addSelectionListener(final MenuManager manager) {
        ISelectionService selectionService = (ISelectionService)this.serviceLocator.getService(ISelectionService.class);
        this.listener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                INatTableWidgetProvider provider = CreateNewElementInTableMenuContributionItem.this.getINatTableWidgetProvider();
                if (provider != null) {
                    manager.setVisible(true);
                    INatTableWidget widget = provider.getNatTableWidget();
                    if (manager.getMenu() != null && !manager.getMenu().isDisposed()) {
                        manager.getMenu().getParentItem().setEnabled(widget.getInstantionMethodHistory().size() != 0);
                    }
                } else {
                    manager.setVisible(false);
                }
                manager.updateAll(true);
            }
        };
        selectionService.addSelectionListener(this.listener);
    }
}

