/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.table.modelexplorer.handlers;

import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CompoundCommand;
import org.eclipse.emf.common.command.UnexecutableCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.edit.command.RemoveCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.papyrus.sasheditor.contentprovider.IPageMngr;
import org.eclipse.papyrus.table.instance.papyrustableinstance.PapyrusTableInstance;
import org.eclipse.papyrus.table.modelexplorer.handlers.AbstractTableModelExplorerHandler;

public class DeleteTableHandler
extends AbstractTableModelExplorerHandler {
    protected Command getCommand() {
        TransactionalEditingDomain editingDomain = this.getEditingDomain();
        IPageMngr pageMngr = this.getPageManager();
        List<PapyrusTableInstance> tables = this.getSelectedTables();
        if (editingDomain != null && pageMngr != null && !tables.isEmpty()) {
            CompoundCommand command = new CompoundCommand();
            for (PapyrusTableInstance table : tables) {
                RecordingCommand sashRemoveComd = new RecordingCommand(editingDomain){

                    protected void doExecute() {
                        if (pageMngr.isOpen((Object)table)) {
                            pageMngr.closePage((Object)table);
                        }
                        pageMngr.removePage((Object)table);
                    }
                };
                EList tabls = table.eResource().getContents();
                command.append((Command)sashRemoveComd);
                command.append((Command)new RemoveCommand((EditingDomain)editingDomain, tabls, (Object)table));
            }
            return command.isEmpty() ? UnexecutableCommand.INSTANCE : command;
        }
        return UnexecutableCommand.INSTANCE;
    }
}

