/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.transition.editor.xtext.ui.contributions;

import com.google.inject.Injector;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.emf.commands.core.command.AbstractTransactionalCommand;
import org.eclipse.papyrus.commands.wrappers.GMFtoEMFCommandWrapper;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.extensionpoints.editors.ui.IPopupEditorHelper;
import org.eclipse.papyrus.transition.editor.xtext.ui.internal.UmlTransitionActivator;
import org.eclipse.papyrus.transition.editor.xtext.umlTransition.BehaviorKind;
import org.eclipse.papyrus.transition.editor.xtext.umlTransition.CallOrSignalEventRule;
import org.eclipse.papyrus.transition.editor.xtext.umlTransition.ChangeEventRule;
import org.eclipse.papyrus.transition.editor.xtext.umlTransition.EventRule;
import org.eclipse.papyrus.transition.editor.xtext.umlTransition.RelativeTimeEventRule;
import org.eclipse.papyrus.transition.editor.xtext.umlTransition.TimeEventRule;
import org.eclipse.papyrus.transition.editor.xtext.umlTransition.TransitionRule;
import org.eclipse.uml2.common.util.UML2Util;
import org.eclipse.uml2.uml.Activity;
import org.eclipse.uml2.uml.Behavior;
import org.eclipse.uml2.uml.CallEvent;
import org.eclipse.uml2.uml.ChangeEvent;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Event;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Operation;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.PackageableElement;
import org.eclipse.uml2.uml.Signal;
import org.eclipse.uml2.uml.SignalEvent;
import org.eclipse.uml2.uml.StateMachine;
import org.eclipse.uml2.uml.TimeEvent;
import org.eclipse.uml2.uml.TimeExpression;
import org.eclipse.uml2.uml.Transition;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.ValueSpecification;
import org.eclipse.xtext.gmf.glue.PopupEditorConfiguration;
import org.eclipse.xtext.gmf.glue.edit.part.DefaultXtextSemanticValidator;
import org.eclipse.xtext.gmf.glue.edit.part.IXTextSemanticValidator;
import org.eclipse.xtext.gmf.glue.edit.part.IXtextEMFReconciler;

public class TransitionPopupEditorConfigurationContribution
extends PopupEditorConfiguration {
    private Transition transition = null;
    private static final String EVENTS = "events";
    private TransitionRule transitionRuleObject = null;

    public IPopupEditorHelper createPopupEditorHelper(Object editPart) {
        IGraphicalEditPart graphicalEditPart = null;
        if (!(editPart instanceof IGraphicalEditPart)) {
            return null;
        }
        graphicalEditPart = (IGraphicalEditPart)editPart;
        if (!(graphicalEditPart.resolveSemanticElement() instanceof Transition)) {
            return null;
        }
        this.transition = (Transition)graphicalEditPart.resolveSemanticElement();
        Injector injector = UmlTransitionActivator.getInstance().getInjector("org.eclipse.papyrus.transition.editor.xtext.UmlTransition");
        String textToEdit = this.getTextToEdit(graphicalEditPart.resolveSemanticElement());
        String fileExtension = ".umltransition";
        IXtextEMFReconciler reconciler = new IXtextEMFReconciler(){

            /*
             * Unable to fully structure code
             */
            public void reconcile(EObject modelObject, EObject xtextObject) {
                modifiedObject = xtextObject;
                if (modelObject instanceof Transition) ** GOTO lbl5
                return;
lbl-1000:
                // 1 sources

                {
                    modifiedObject = modifiedObject.eContainer();
lbl5:
                    // 2 sources

                    ** while (xtextObject != null && !(xtextObject instanceof TransitionRule))
                }
lbl6:
                // 1 sources

                if (modifiedObject == null) {
                    return;
                }
                TransitionPopupEditorConfigurationContribution.access$1(TransitionPopupEditorConfigurationContribution.this, (TransitionRule)xtextObject);
                updateCommand = new UpdateUMLTransitionCommand(TransitionPopupEditorConfigurationContribution.access$2(TransitionPopupEditorConfigurationContribution.this));
                dom = EditorUtils.getTransactionalEditingDomain();
                dom.getCommandStack().execute((Command)new GMFtoEMFCommandWrapper((ICommand)updateCommand));
            }
        };
        return super.createPopupEditorHelper(graphicalEditPart, injector, reconciler, textToEdit, fileExtension, (IXTextSemanticValidator)new DefaultXtextSemanticValidator());
    }

    public String getTextToEdit(Object editedObject) {
        if (editedObject instanceof Transition) {
            Transition transition = (Transition)editedObject;
            String textToEdit = "";
            if (!transition.getTriggers().isEmpty()) {
                boolean isFirstTrigger = true;
                for (Trigger t : transition.getTriggers()) {
                    if (!isFirstTrigger) {
                        textToEdit = String.valueOf(textToEdit) + ", ";
                    } else {
                        isFirstTrigger = false;
                    }
                    Event e = t.getEvent();
                    if (e instanceof CallEvent) {
                        textToEdit = String.valueOf(textToEdit) + ((CallEvent)e).getOperation().getName();
                        continue;
                    }
                    if (e instanceof SignalEvent) {
                        textToEdit = String.valueOf(textToEdit) + ((SignalEvent)e).getSignal().getName();
                        continue;
                    }
                    if (e instanceof ChangeEvent) {
                        textToEdit = String.valueOf(textToEdit) + "when " + "\"" + this.retrieveBody((OpaqueExpression)((ChangeEvent)e).getChangeExpression(), "Natural language") + "\"";
                        continue;
                    }
                    if (e instanceof TimeEvent) {
                        String absRelPrefix = ((TimeEvent)e).isRelative() ? "after " : "at ";
                        textToEdit = String.valueOf(textToEdit) + absRelPrefix + "\"" + this.retrieveBody((OpaqueExpression)((TimeEvent)e).getWhen().getExpr(), "Natural language") + "\"";
                        continue;
                    }
                    textToEdit = String.valueOf(textToEdit) + "all";
                }
            }
            if (transition.getGuard() != null && transition.getGuard().getSpecification() != null) {
                textToEdit = String.valueOf(textToEdit) + " [" + "\"" + this.retrieveBody((OpaqueExpression)transition.getGuard().getSpecification(), "Natural language") + "\"" + "]";
            }
            if (transition.getEffect() != null) {
                textToEdit = String.valueOf(textToEdit) + " / ";
                String behaviorKind = "";
                behaviorKind = String.valueOf(behaviorKind) + (behaviorKind.equals("") && transition.getEffect() instanceof Activity ? "Activity " : "");
                behaviorKind = String.valueOf(behaviorKind) + (behaviorKind.equals("") && transition.getEffect() instanceof StateMachine ? "StateMachine " : "");
                behaviorKind = String.valueOf(behaviorKind) + (behaviorKind.equals("") && transition.getEffect() instanceof OpaqueBehavior ? "OpaqueBehavior " : "");
                textToEdit = String.valueOf(textToEdit) + behaviorKind + " " + transition.getEffect().getName();
            }
            return textToEdit;
        }
        return "not a State";
    }

    private String retrieveBody(OpaqueExpression exp, String languageName) {
        String body = "";
        if (exp == null) {
            return body;
        }
        int index = 0;
        for (String _languageName : exp.getLanguages()) {
            if (_languageName.equals(languageName)) {
                if (index < exp.getBodies().size()) {
                    return (String)exp.getBodies().get(index);
                }
                return "";
            }
            ++index;
        }
        return body;
    }

    static /* synthetic */ void access$1(TransitionPopupEditorConfigurationContribution transitionPopupEditorConfigurationContribution, TransitionRule transitionRule) {
        transitionPopupEditorConfigurationContribution.transitionRuleObject = transitionRule;
    }

    static /* synthetic */ Transition access$2(TransitionPopupEditorConfigurationContribution transitionPopupEditorConfigurationContribution) {
        return transitionPopupEditorConfigurationContribution.transition;
    }

    protected class UpdateUMLTransitionCommand
    extends AbstractTransactionalCommand {
        private Transition transition;
        private String newName;
        private List<Trigger> newTriggers;
        private Constraint newConstraint;
        private Behavior newEffectBehavior;

        protected CommandResult doExecuteWithResult(IProgressMonitor arg0, IAdaptable arg1) throws ExecutionException {
            Behavior effect = this.transition.getEffect();
            this.transition.setEffect(null);
            if (effect != null) {
                effect.destroy();
            }
            for (Trigger t : this.transition.getTriggers()) {
                Event e = t.getEvent();
                t.setEvent(null);
                if (UML2Util.getNonNavigableInverseReferences((EObject)e).size() != 0) continue;
                e.destroy();
            }
            this.transition.getTriggers().removeAll((Collection)this.transition.getTriggers());
            Constraint guard = this.transition.getGuard();
            this.transition.setGuard(null);
            if (guard != null) {
                guard.destroy();
            }
            if (TransitionPopupEditorConfigurationContribution.this.transitionRuleObject.getTriggers() != null) {
                for (EventRule eventRule : TransitionPopupEditorConfigurationContribution.this.transitionRuleObject.getTriggers()) {
                    Trigger newTrigger = UMLFactory.eINSTANCE.createTrigger();
                    this.newTriggers.add(newTrigger);
                    newTrigger.setEvent(this.createUMLEvent(eventRule));
                }
                this.transition.getTriggers().addAll(this.newTriggers);
            }
            if (TransitionPopupEditorConfigurationContribution.this.transitionRuleObject.getGuard() != null && TransitionPopupEditorConfigurationContribution.this.transitionRuleObject.getGuard().getConstraint() != null) {
                this.newConstraint = this.transition.createGuard("");
                OpaqueExpression guardSpecification = UMLFactory.eINSTANCE.createOpaqueExpression();
                guardSpecification.getLanguages().add((Object)"Natural language");
                guardSpecification.getBodies().add((Object)TransitionPopupEditorConfigurationContribution.this.transitionRuleObject.getGuard().getConstraint());
                this.newConstraint.setSpecification((ValueSpecification)guardSpecification);
            }
            if (TransitionPopupEditorConfigurationContribution.this.transitionRuleObject.getEffect() != null && TransitionPopupEditorConfigurationContribution.this.transitionRuleObject.getEffect().getKind() != null && TransitionPopupEditorConfigurationContribution.this.transitionRuleObject.getEffect().getBehaviorName() != null) {
                this.newEffectBehavior = this.createUMLBehavior(TransitionPopupEditorConfigurationContribution.this.transitionRuleObject.getEffect().getKind(), TransitionPopupEditorConfigurationContribution.this.transitionRuleObject.getEffect().getBehaviorName());
                this.transition.setEffect(this.newEffectBehavior);
            }
            return CommandResult.newOKCommandResult((Object)this.transition);
        }

        protected Package getEventPackage() {
            Package np = this.transition.getNearestPackage();
            int i = 0;
            while (true) {
                PackageableElement ep;
                String name = TransitionPopupEditorConfigurationContribution.EVENTS;
                if (i > 0) {
                    name = String.valueOf(name) + i;
                }
                if ((ep = np.getPackagedElement(name)) instanceof Package) {
                    return (Package)ep;
                }
                if (ep == null) {
                    return np.createNestedPackage(name);
                }
                ++i;
            }
        }

        private CallEvent getOrCreateCallEvent(Operation operation) {
            String name = "CE - " + operation.getClass_().getName() + " - " + operation.getName();
            Package eventPkg = this.getEventPackage();
            for (PackageableElement existingPE : eventPkg.getPackagedElements()) {
                if (!(existingPE instanceof CallEvent) || ((CallEvent)existingPE).getOperation() != operation) continue;
                ((CallEvent)existingPE).setName(name);
                return (CallEvent)existingPE;
            }
            CallEvent ce = UMLFactory.eINSTANCE.createCallEvent();
            ce.setOperation(operation);
            ce.setName(name);
            eventPkg.getPackagedElements().add((Object)ce);
            return ce;
        }

        private SignalEvent getOrCreateSignalEvent(Signal signal) {
            Package eventPkg = this.getEventPackage();
            String name = "SE - " + signal.getName();
            for (PackageableElement existingPE : eventPkg.getPackagedElements()) {
                if (!(existingPE instanceof SignalEvent) || ((SignalEvent)existingPE).getSignal() != signal) continue;
                ((SignalEvent)existingPE).setName(name);
                return (SignalEvent)existingPE;
            }
            SignalEvent se = UMLFactory.eINSTANCE.createSignalEvent();
            se.setSignal(signal);
            se.setName(name);
            eventPkg.getPackagedElements().add((Object)se);
            return se;
        }

        private ChangeEvent getOrCreateChangeEvent(String opaqueChangeExpr) {
            Package eventPkg = this.getEventPackage();
            String name = "CE - " + opaqueChangeExpr;
            for (PackageableElement existingPE : eventPkg.getPackagedElements()) {
                EList bodies;
                ValueSpecification vs;
                if (!(existingPE instanceof ChangeEvent) || !((vs = ((ChangeEvent)existingPE).getChangeExpression()) instanceof OpaqueExpression) || (bodies = ((OpaqueExpression)vs).getBodies()).size() <= 0 || !((String)bodies.get(0)).equals(opaqueChangeExpr)) continue;
                ((ChangeEvent)existingPE).setName(name);
                return (ChangeEvent)existingPE;
            }
            ChangeEvent ce = UMLFactory.eINSTANCE.createChangeEvent();
            OpaqueExpression changeExpression = UMLFactory.eINSTANCE.createOpaqueExpression();
            changeExpression.getLanguages().add((Object)"Natural language");
            changeExpression.getBodies().add((Object)opaqueChangeExpr);
            ce.setChangeExpression((ValueSpecification)changeExpression);
            ce.setName(name);
            eventPkg.getPackagedElements().add((Object)ce);
            return ce;
        }

        private TimeEvent getOrCreateTimeEvent(String opaqueWhen, boolean isRelative) {
            Package eventPkg = this.getEventPackage();
            String name = "TE - " + opaqueWhen;
            for (PackageableElement existingPE : eventPkg.getPackagedElements()) {
                EList bodies;
                ValueSpecification vs;
                if (!(existingPE instanceof TimeEvent) || !((vs = ((TimeEvent)existingPE).getWhen().getExpr()) instanceof OpaqueExpression) || (bodies = ((OpaqueExpression)vs).getBodies()).size() <= 0 || !((String)bodies.get(0)).equals(opaqueWhen)) continue;
                ((TimeEvent)existingPE).setName(name);
                return (TimeEvent)existingPE;
            }
            TimeEvent te = UMLFactory.eINSTANCE.createTimeEvent();
            OpaqueExpression timeExpressionExp = UMLFactory.eINSTANCE.createOpaqueExpression();
            timeExpressionExp.getLanguages().add((Object)"Natural language");
            timeExpressionExp.getBodies().add((Object)opaqueWhen);
            TimeExpression timeExpression = UMLFactory.eINSTANCE.createTimeExpression();
            timeExpression.setExpr((ValueSpecification)timeExpressionExp);
            te.setWhen(timeExpression);
            te.setIsRelative(isRelative);
            te.setName(name);
            eventPkg.getPackagedElements().add((Object)te);
            return te;
        }

        private Event createUMLEvent(EventRule eventRule) {
            Object e = null;
            if (eventRule instanceof CallOrSignalEventRule) {
                CallOrSignalEventRule callOrSignalEventRule = (CallOrSignalEventRule)eventRule;
                if (callOrSignalEventRule.getOperationOrSignal() != null) {
                    NamedElement operationOrSignal = callOrSignalEventRule.getOperationOrSignal();
                    e = operationOrSignal instanceof Operation ? this.getOrCreateCallEvent((Operation)operationOrSignal) : this.getOrCreateSignalEvent((Signal)operationOrSignal);
                }
            } else if (eventRule instanceof ChangeEventRule) {
                ChangeEventRule changeEventRule = (ChangeEventRule)eventRule;
                if (changeEventRule.getExp() != null) {
                    e = this.getOrCreateChangeEvent(changeEventRule.getExp());
                }
            } else if (eventRule instanceof TimeEventRule) {
                TimeEventRule timeEventRule = (TimeEventRule)eventRule;
                if (timeEventRule.getExpr() != null) {
                    e = this.getOrCreateTimeEvent(timeEventRule.getExpr(), timeEventRule instanceof RelativeTimeEventRule);
                }
            } else {
                e = UMLFactory.eINSTANCE.createAnyReceiveEvent();
                this.getEventPackage().getPackagedElements().add(e);
                e.setName("any");
            }
            return e;
        }

        private Behavior createUMLBehavior(BehaviorKind kind, String name) {
            if (kind == null) {
                return null;
            }
            Activity behavior = null;
            switch (kind) {
                case ACTIVITY: {
                    behavior = UMLFactory.eINSTANCE.createActivity();
                    break;
                }
                case OPAQUE_BEHAVIOR: {
                    behavior = UMLFactory.eINSTANCE.createOpaqueBehavior();
                    break;
                }
                case STATE_MACHINE: {
                    behavior = UMLFactory.eINSTANCE.createStateMachine();
                    break;
                }
            }
            behavior.setName(name);
            return behavior;
        }

        public UpdateUMLTransitionCommand(Transition transition) {
            super(EditorUtils.getTransactionalEditingDomain(), "Transition Update", UpdateUMLTransitionCommand.getWorkspaceFiles((EObject)transition));
            this.newName = "";
            this.newTriggers = new ArrayList<Trigger>();
            this.newConstraint = null;
            this.newEffectBehavior = null;
            this.transition = transition;
        }
    }
}

