/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.ui.perspectiveconfiguration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.papyrus.ui.perspectiveconfiguration.Configuration;
import org.eclipse.papyrus.ui.perspectiveconfiguration.ConfigurationService;
import org.eclipse.papyrus.ui.perspectiveconfiguration.CustomizeActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PerspectiveAdapter;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.internal.Perspective;
import org.eclipse.ui.internal.WorkbenchPage;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.provisional.application.IActionBarConfigurer2;
import org.eclipse.ui.internal.registry.ActionSetDescriptor;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.IActionSetDescriptor;
import org.eclipse.ui.internal.registry.PerspectiveRegistry;
import org.eclipse.ui.menus.IMenuService;

public class PapyrusPerspectiveListener
extends PerspectiveAdapter {
    private IWorkbenchWindow window;
    protected ConfigurationService configurationservice;
    protected ArrayList<PreferenceNode> hiddenRootPref = new ArrayList();

    public PapyrusPerspectiveListener(IWorkbenchWindow window) {
        this.window = window;
        this.configurationservice = new ConfigurationService();
        if (window.getActivePage() != null) {
            IPerspectiveDescriptor openedPerspectiveDescriptor = window.getActivePage().getPerspective();
            if (this.configurationservice.getConfiguration(openedPerspectiveDescriptor.getId()) != null && !this.isAlreadySave(openedPerspectiveDescriptor.getId())) {
                this.updateTooling(openedPerspectiveDescriptor);
                window.getActivePage().savePerspective();
            }
            this.updatePreferencePage(openedPerspectiveDescriptor);
        }
    }

    public boolean isAlreadySave(String perspectiveID) {
        PerspectiveRegistry perspRegistry = (PerspectiveRegistry)WorkbenchPlugin.getDefault().getPerspectiveRegistry();
        try {
            IMemento memento = perspRegistry.getCustomPersp(perspectiveID);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void perspectiveActivated(IWorkbenchPage page, IPerspectiveDescriptor perspectivedescriptor) {
        super.perspectiveActivated(page, perspectivedescriptor);
        if (this.configurationservice.getConfiguration(perspectivedescriptor.getId()) != null && !this.isAlreadySave(perspectivedescriptor.getId())) {
            this.updateTooling(perspectivedescriptor);
            page.savePerspective();
        }
        this.updatePreferencePage(perspectivedescriptor);
        Perspective perspective = ((WorkbenchPage)page).findPerspective(perspectivedescriptor);
        if (perspective != null) {
            perspective.updateActionBars();
        }
    }

    protected void updatePreferencePage(IPerspectiveDescriptor perspectivedescriptor) {
        if (this.configurationservice.getConfiguration(perspectivedescriptor.getId()) != null) {
            Configuration configuration = this.configurationservice.getConfiguration(perspectivedescriptor.getId());
            IPreferenceNode[] preferencepagelist = this.window.getWorkbench().getPreferenceManager().getRootSubNodes();
            int i = 0;
            while (i < preferencepagelist.length) {
                if (preferencepagelist[i] instanceof PreferenceNode) {
                    PreferenceNode node = (PreferenceNode)preferencepagelist[i];
                    if (!configuration.getPreferenceID().contains(node.getId())) {
                        this.hiddenRootPref.add(node);
                    }
                }
                ++i;
            }
            Iterator<PreferenceNode> iteratorpreftoremove = this.hiddenRootPref.iterator();
            while (iteratorpreftoremove.hasNext()) {
                this.window.getWorkbench().getPreferenceManager().remove((IPreferenceNode)iteratorpreftoremove.next());
            }
        } else {
            Iterator<PreferenceNode> iteratorpreftoremove = this.hiddenRootPref.iterator();
            while (iteratorpreftoremove.hasNext()) {
                this.window.getWorkbench().getPreferenceManager().addToRoot((IPreferenceNode)iteratorpreftoremove.next());
            }
            this.hiddenRootPref.clear();
        }
    }

    protected void updateTooling(IPerspectiveDescriptor perspectivedescriptor) {
        CustomizeActionBars customizeActionBars = this.loadData();
        if (this.configurationservice.getConfiguration(perspectivedescriptor.getId()) != null) {
            Configuration configuration = this.configurationservice.getConfiguration(perspectivedescriptor.getId());
            WorkbenchPage worbenchPage = (WorkbenchPage)this.window.getActivePage();
            Perspective perspective = worbenchPage.findPerspective(perspectivedescriptor);
            ICommandService cmdService = (ICommandService)worbenchPage.getActivePart().getSite().getService(ICommandService.class);
            ArrayList<String> commandIdToRemove = new ArrayList<String>();
            try {
                int i = 0;
                while (i < cmdService.getDefinedCommands().length) {
                    if (!configuration.getCategoryIDList().contains(cmdService.getDefinedCommands()[i].getCategory().getId())) {
                        commandIdToRemove.add(cmdService.getDefinedCommands()[i].getId());
                    }
                    ++i;
                }
                i = 0;
                while (i < cmdService.getDefinedCommands().length) {
                    if (!configuration.getCommandIDList().contains(cmdService.getDefinedCommands()[i].getId())) {
                        if (!configuration.getCategoryIDList().contains(cmdService.getDefinedCommands()[i].getCategory().getId()) && !commandIdToRemove.contains(cmdService.getDefinedCommands()[i].getId())) {
                            commandIdToRemove.add(cmdService.getDefinedCommands()[i].getId());
                        }
                    } else if (commandIdToRemove.contains(cmdService.getDefinedCommands()[i].getId())) {
                        commandIdToRemove.remove(cmdService.getDefinedCommands()[i].getId());
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                System.err.println(e);
            }
            perspective.getHiddenMenuItems().clear();
            perspective.getHiddenToolbarItems().clear();
            ArrayList<IActionSetDescriptor> actionSetToRemove = new ArrayList<IActionSetDescriptor>();
            for (IActionSetDescriptor currentActionSetDescriptor : customizeActionBars.getActionSet()) {
                if (configuration.getActionSetIDList().contains(currentActionSetDescriptor.getId())) continue;
                actionSetToRemove.add(currentActionSetDescriptor);
            }
            ArrayList<String> menuToRemove = new ArrayList<String>();
            int i = 0;
            while (i < customizeActionBars.getMenuManager().getItems().length) {
                if (!configuration.getMenuIDList().contains(customizeActionBars.getMenuManager().getItems()[i].getId())) {
                    menuToRemove.add(customizeActionBars.getMenuManager().getItems()[i].getId());
                }
                ++i;
            }
            ArrayList<String> toolbarToRemove = new ArrayList<String>();
            int i2 = 0;
            while (i2 < customizeActionBars.getToolBarManager().getItems().length) {
                if (!configuration.getToolBarID().contains(customizeActionBars.getToolBarManager().getItems()[i2].getId())) {
                    toolbarToRemove.add(customizeActionBars.getToolBarManager().getItems()[i2].getId());
                }
                ++i2;
            }
            perspective.getHiddenMenuItems().addAll(commandIdToRemove);
            perspective.getHiddenToolbarItems().addAll(commandIdToRemove);
            perspective.turnOffActionSets(actionSetToRemove.toArray(new IActionSetDescriptor[actionSetToRemove.size()]));
            perspective.getHiddenMenuItems().addAll(menuToRemove);
            perspective.getHiddenToolbarItems().addAll(toolbarToRemove);
            perspective.updateActionBars();
        }
    }

    protected CustomizeActionBars loadData() {
        CustomizeActionBars ownedActionBar = new CustomizeActionBars(null);
        ActionSetRegistry reg = WorkbenchPlugin.getDefault().getActionSetRegistry();
        IActionSetDescriptor[] sets = reg.getActionSets();
        IActionSetDescriptor[] actionSetDescriptors = ((WorkbenchPage)this.window.getActivePage()).getActionSets();
        List<IActionSetDescriptor> initiallyAvailableActionSets = Arrays.asList(actionSetDescriptors);
        ownedActionBar.setActionSet(initiallyAvailableActionSets);
        ((WorkbenchWindow)this.window).fillActionBars((IActionBarConfigurer2)ownedActionBar, 7);
        int i = 0;
        while (i < sets.length) {
            ActionSetDescriptor actionSetDescriptor = (ActionSetDescriptor)sets[i];
            ++i;
        }
        IMenuService menuService = (IMenuService)this.window.getService(IMenuService.class);
        menuService.populateContributionManager((ContributionManager)ownedActionBar.getMenuManager(), "menu:org.eclipse.ui.main.menu");
        int i2 = 0;
        while (i2 < ownedActionBar.getMenuManager().getItems().length) {
            IContributionItem iContributionItem = ownedActionBar.getMenuManager().getItems()[i2];
            ++i2;
        }
        IToolBarManager toolBarManager = ownedActionBar.getToolBarManager();
        menuService.populateContributionManager((ContributionManager)toolBarManager, "toolbar:org.eclipse.ui.main.toolbar");
        int i3 = 0;
        while (i3 < ownedActionBar.getToolBarManager().getItems().length) {
            IContributionItem iContributionItem = toolBarManager.getItems()[i3];
            ++i3;
        }
        return ownedActionBar;
    }

    public void perspectiveDeactivated(IWorkbenchPage page, IPerspectiveDescriptor perspective) {
    }
}

