/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.ui.resources.refactoring;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.gmf.runtime.notation.Diagram;
import org.eclipse.gmf.runtime.notation.NotationPackage;
import org.eclipse.papyrus.ui.resources.refactoring.ui.RenameParticipantsDialog;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModelParticipantHelpers {
    public static Set<IResource> getResourceToFix(IFile initialFile) {
        RenameDialogRunnable runnable = new RenameDialogRunnable(initialFile);
        Display.getDefault().syncExec((Runnable)runnable);
        return new HashSet<IResource>(runnable.getFiles());
    }

    public static Set<IResource> getRelatedFiles(IFile initialFile) {
        IFile diFile;
        IContainer parent = initialFile.getParent();
        IPath initialPath = initialFile.getFullPath();
        IPath diPath = null;
        if ("di".equalsIgnoreCase(initialPath.getFileExtension())) {
            diPath = initialPath;
        } else {
            try {
                IResource[] iResourceArray = parent.members();
                int n = iResourceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource r = iResourceArray[n2];
                    IPath p = r.getFullPath();
                    if ("di".equalsIgnoreCase(p.getFileExtension()) && p.removeFileExtension().equals((Object)initialPath.removeFileExtension())) {
                        diPath = p;
                        break;
                    }
                    ++n2;
                }
            }
            catch (CoreException r) {
                // empty catch block
            }
        }
        HashSet<IResource> relatedFiles = new HashSet<IResource>();
        if (diPath != null && (diFile = parent.getFile(diPath.makeRelativeTo(parent.getFullPath()))).exists()) {
            try {
                IResource[] iResourceArray = diFile.getParent().members();
                int n = iResourceArray.length;
                int n3 = 0;
                while (n3 < n) {
                    IResource r = iResourceArray[n3];
                    if (r.getFullPath().removeFileExtension().lastSegment().equals(diFile.getFullPath().removeFileExtension().lastSegment())) {
                        relatedFiles.add(r);
                    }
                    ++n3;
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        }
        if (relatedFiles.contains(initialFile)) {
            relatedFiles.remove(initialFile);
        }
        return relatedFiles;
    }

    private static List<IResource> getModelFilesFromNotationResource(Resource notationResource) {
        ArrayList<IResource> modelFiles = new ArrayList<IResource>();
        for (EObject eObject : notationResource.getContents()) {
            IResource modelFile;
            URI modelURI;
            Diagram diagram;
            InternalEObject element;
            if (!(eObject instanceof Diagram) || (element = (InternalEObject)(diagram = (Diagram)eObject).eGet((EStructuralFeature)NotationPackage.Literals.VIEW__ELEMENT, false)) == null || !element.eIsProxy() || !(modelURI = element.eProxyURI().trimFragment()).isPlatform() || (modelFile = ResourcesPlugin.getWorkspace().getRoot().findMember(modelURI.toPlatformString(true))) == null) continue;
            modelFiles.add(modelFile);
        }
        return modelFiles;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class RenameDialogRunnable
    implements Runnable {
        private IFile initialFile;
        private RenameParticipantsDialog renameParticipantsDialog;

        public RenameDialogRunnable(IFile file) {
            this.initialFile = file;
        }

        @Override
        public void run() {
            this.renameParticipantsDialog = new RenameParticipantsDialog(Display.getDefault().getActiveShell(), this.initialFile);
            this.renameParticipantsDialog.open();
        }

        public Collection<? extends IResource> getFiles() {
            return this.renameParticipantsDialog.getFiles();
        }
    }
}

