/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.ui.resources.refactoring;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.NullChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;
import org.eclipse.ltk.core.refactoring.resource.MoveResourceChange;
import org.eclipse.papyrus.ui.resources.refactoring.Messages;
import org.eclipse.papyrus.ui.resources.refactoring.ModelParticipantHelpers;

public class MoveModelParticipant
extends MoveParticipant {
    private Set<IResource> filesToMove = new HashSet<IResource>();
    private IContainer destination;

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        return new RefactoringStatus();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        ArrayList<MoveResourceChange> changes = new ArrayList<MoveResourceChange>(this.filesToMove.size());
        for (IResource path : this.filesToMove) {
            if (!path.exists()) continue;
            changes.add(new MoveResourceChange(path, this.destination));
        }
        if (changes.isEmpty()) {
            return new NullChange();
        }
        return new CompositeChange(this.getName(), changes.toArray(new Change[changes.size()]));
    }

    public String getName() {
        return Messages.MoveModelParticipant_Name;
    }

    protected boolean initialize(Object element) {
        if (!(element instanceof IFile)) {
            return false;
        }
        IFile file = (IFile)element;
        Object _destination = this.getArguments().getDestination();
        if (_destination instanceof IContainer) {
            this.destination = (IContainer)_destination;
        }
        this.filesToMove = ModelParticipantHelpers.getRelatedFiles(file);
        return this.filesToMove.size() > 0;
    }
}

