/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.ui.resources.refactoring.ui;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.papyrus.ui.resources.refactoring.ui.IScopeChooser;
import org.eclipse.papyrus.ui.resources.refactoring.ui.Messages;
import org.eclipse.papyrus.ui.resources.refactoring.ui.ScopeChooser;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RenameParticipantsDialog
extends TitleAreaDialog {
    private final FormToolkit formToolkit = new FormToolkit(Display.getDefault());
    private final IFile context;
    private FormText formDescription;
    protected IScopeChooser currentScope;

    public RenameParticipantsDialog(Shell parentShell, IFile context) {
        super(parentShell);
        this.context = context;
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(Messages.RenameParticipantsDialog_SELECT_RENAME_OPTION);
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(1, false));
        container.setLayoutData((Object)new GridData(1808));
        Section sctnOptions = this.formToolkit.createSection(container, 320);
        sctnOptions.setDescription("");
        sctnOptions.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        this.formToolkit.paintBordersFor((Composite)sctnOptions);
        sctnOptions.setText(Messages.RenameParticipantsDialog_OPTIONS);
        Composite composite = new Composite((Composite)sctnOptions, 0);
        this.formToolkit.adapt(composite);
        this.formToolkit.paintBordersFor(composite);
        sctnOptions.setClient((Control)composite);
        composite.setLayout((Layout)new GridLayout(1, false));
        FormText formText = this.formToolkit.createFormText(composite, false);
        formText.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 1, 1));
        this.formToolkit.paintBordersFor((Composite)formText);
        formText.setText(Messages.RenameParticipantsDialog_DESCRIPTION, true, false);
        ComboViewer comboViewer = new ComboViewer(composite, 8);
        comboViewer.setUseHashlookup(true);
        comboViewer.setLabelProvider((IBaseLabelProvider)new ILabelProvider(){

            public void removeListener(ILabelProviderListener listener) {
            }

            public boolean isLabelProperty(Object element, String property) {
                return true;
            }

            public void dispose() {
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public String getText(Object element) {
                if (element instanceof IScopeChooser) {
                    IScopeChooser scope = (IScopeChooser)element;
                    return scope.getName();
                }
                return null;
            }

            public Image getImage(Object element) {
                return null;
            }
        });
        comboViewer.setContentProvider((IContentProvider)new IStructuredContentProvider(){

            public Object[] getElements(Object inputElement) {
                return (Object[])inputElement;
            }

            public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            }

            public void dispose() {
            }
        });
        Combo combo = comboViewer.getCombo();
        combo.setLayoutData((Object)new GridData(4, 4, true, false, 1, 1));
        this.formToolkit.paintBordersFor((Composite)combo);
        Group grpDescription = new Group(composite, 0);
        grpDescription.setLayout((Layout)new GridLayout(1, false));
        grpDescription.setLayoutData((Object)new GridData(4, 4, true, true, 1, 1));
        grpDescription.setText(Messages.RenameParticipantsDialog_DESCRIPTION_LABEL);
        this.formToolkit.adapt((Composite)grpDescription);
        this.formToolkit.paintBordersFor((Composite)grpDescription);
        this.formDescription = this.formToolkit.createFormText((Composite)grpDescription, false);
        this.formDescription.setLayoutData((Object)new GridData(4, 0x1000000, true, true, 1, 1));
        this.formToolkit.paintBordersFor((Composite)this.formDescription);
        this.formDescription.setText("", false, false);
        comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selec;
                if (event.getSelection() instanceof IStructuredSelection && (selec = (IStructuredSelection)event.getSelection()).getFirstElement() instanceof IScopeChooser) {
                    IScopeChooser chooser = (IScopeChooser)selec.getFirstElement();
                    RenameParticipantsDialog.this.formDescription.setText(chooser.getDescription(), true, false);
                    RenameParticipantsDialog.this.currentScope = chooser;
                }
            }
        });
        Object[] input = this.getInput();
        comboViewer.setInput((Object)input);
        comboViewer.setSelection((ISelection)new StructuredSelection(input[0]));
        return area;
    }

    private Object[] getInput() {
        final ScopeChooser.ScopeChooserVisitor visitor = new ScopeChooser.ScopeChooserVisitor();
        return new IScopeChooser[]{new ScopeChooser(Messages.RenameParticipantsDialog_NAME_PROJECT, Messages.RenameParticipantsDialog_DESCRIPTION_PROJECT){

            @Override
            public List<IFile> getRelatedFiles(IFile f) {
                try {
                    f.getProject().accept((IResourceVisitor)visitor, 2, 4);
                    return visitor.getFiles();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return Collections.emptyList();
                }
            }
        }, new ScopeChooser(Messages.RenameParticipantsDialog_NAME_WORKSPACE, Messages.RenameParticipantsDialog_DESCRIPTION_WORKSPACE){

            @Override
            public List<IFile> getRelatedFiles(IFile f) {
                try {
                    ResourcesPlugin.getWorkspace().getRoot().accept((IResourceVisitor)visitor, 2, 4);
                    return visitor.getFiles();
                }
                catch (CoreException e) {
                    e.printStackTrace();
                    return Collections.emptyList();
                }
            }
        }, new ScopeChooser(Messages.RenameParticipantsDialog_NAME_NO_ANALYSIS, Messages.RenameParticipantsDialog_DESCRIPTION_NO_ANALYSIS){

            @Override
            public List<IFile> getRelatedFiles(IFile f) {
                return Arrays.asList(f);
            }
        }};
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
    }

    protected Point getInitialSize() {
        return new Point(450, 300);
    }

    public Collection<? extends IResource> getFiles() {
        return this.currentScope.getRelatedFiles(this.context);
    }
}

