/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.ui.toolbox.dialog;

import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class InformationDialog
extends MessageDialog {
    private IPreferenceStore ps;
    private String preference;
    private Button rememberChoice;

    public InformationDialog(Shell parentShell, String dialogTitle, String message, IPreferenceStore ps, String preference) {
        this(parentShell, dialogTitle, message, ps, preference, 32, 2, new String[]{IDialogConstants.OK_LABEL});
    }

    public InformationDialog(Shell parentShell, String dialogTitle, String message, IPreferenceStore ps, String preference, int style, int messageDialogType, String[] labels) {
        super(parentShell, dialogTitle, null, message, messageDialogType, labels, style);
        this.ps = ps;
        this.preference = preference;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        if (this.ps != null && this.preference != null && this.preference.length() > 0) {
            this.rememberChoice = new Button(container, 32);
            this.rememberChoice.setText("Do not show again");
        }
        return container;
    }

    public int open() {
        if (this.ps != null && this.preference != null && this.preference.length() > 0 && this.ps.getBoolean(this.preference)) {
            return 0;
        }
        return super.open();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0 && this.rememberChoice != null && this.rememberChoice.getSelection() && this.ps != null && this.preference != null && this.preference.length() > 0) {
            this.ps.setValue(this.preference, true);
        }
        super.buttonPressed(buttonId);
    }
}

