/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.ui.toolbox.notification.builders;

import org.eclipse.papyrus.ui.toolbox.notification.IBuilder;
import org.eclipse.papyrus.ui.toolbox.notification.ICompositeCreator;
import org.eclipse.papyrus.ui.toolbox.notification.INotification;
import org.eclipse.papyrus.ui.toolbox.notification.builders.NotificationBuilder;
import org.eclipse.papyrus.ui.toolbox.notification.builders.PropertyWrapper;
import org.eclipse.papyrus.ui.toolbox.notification.dialogs.AsyncNotification;
import org.eclipse.papyrus.ui.toolbox.notification.dialogs.ImagePapyrusAsyncNotificationPopup;
import org.eclipse.papyrus.ui.toolbox.notification.dialogs.PapyrusAsyncNotificationPopup;
import org.eclipse.papyrus.ui.toolbox.notification.utils.PapyrusControlsFactory;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AsyncNotifierBuilder
implements IBuilder {
    public INotification build(PropertyWrapper wrapper, FormToolkit toolkit) {
        PapyrusAsyncNotificationPopup popup = null;
        if (wrapper.getComposite() != null) {
            final ICompositeCreator composite = wrapper.getComposite();
            popup = wrapper.getType() != null ? new ImagePapyrusAsyncNotificationPopup(Display.getDefault(), toolkit, wrapper.getType()){

                protected void doCreateClient(Composite parent) {
                    PapyrusControlsFactory.createCompositeWithType(this.getShell(), null, parent, this.type, this.image, this.text, false, composite, this.context);
                }
            } : new PapyrusAsyncNotificationPopup(Display.getDefault(), toolkit){

                protected void doCreateClient(Composite parent) {
                    Composite compo = composite.createComposite(parent, this.toolkit);
                    this.setCompositeCreated(compo);
                }
            };
        } else {
            popup = wrapper.getType() != null ? new ImagePapyrusAsyncNotificationPopup(Display.getDefault(), toolkit, wrapper.getType()) : new PapyrusAsyncNotificationPopup(Display.getDefault(), toolkit);
            String text = wrapper.getMessage();
            if (text == null) {
                text = "no text";
            }
            popup.setText(text);
        }
        if (wrapper.getDelay() != null) {
            popup.setDelayClose(wrapper.getDelay());
        }
        if (wrapper.getActions() != null) {
            popup.addAllRunnable(wrapper.getActions());
        }
        popup.setTitle(wrapper.getTitle() == null ? "Papyrus" : wrapper.getTitle());
        AsyncNotification notification = new AsyncNotification(popup);
        popup.setINotification(notification);
        popup.open();
        return notification;
    }

    public boolean accept(String parameterName, Object value) {
        if (NotificationBuilder.ASYNCHRONOUS.equals(parameterName)) {
            return value instanceof Boolean && (Boolean)value != false;
        }
        if (NotificationBuilder.TEMPORARY.equals(parameterName)) {
            return value instanceof Boolean && (Boolean)value != false;
        }
        if (NotificationBuilder.MESSAGE.equals(parameterName)) {
            return true;
        }
        if (NotificationBuilder.COMPOSITE.equals(parameterName)) {
            return true;
        }
        if (NotificationBuilder.ACTION.equals(parameterName)) {
            return true;
        }
        if (NotificationBuilder.DELAY.equals(parameterName)) {
            return true;
        }
        if (NotificationBuilder.IMAGE.equals(parameterName)) {
            return true;
        }
        if (NotificationBuilder.TYPE.equals(parameterName)) {
            return true;
        }
        if (NotificationBuilder.HTML.equals(parameterName)) {
            return value instanceof Boolean && (Boolean)value == false;
        }
        return NotificationBuilder.TITLE.equals(parameterName);
    }
}

