/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.ui.toolbox.notification.dialogs;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.papyrus.core.utils.PapyrusImageUtils;
import org.eclipse.papyrus.ui.toolbox.notification.ICompositeCreator;
import org.eclipse.papyrus.ui.toolbox.notification.INotification;
import org.eclipse.papyrus.ui.toolbox.notification.NotificationRunnable;
import org.eclipse.papyrus.ui.toolbox.notification.PapyrusToolkit;
import org.eclipse.papyrus.ui.toolbox.notification.builders.IContext;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PapyrusPopup
extends Dialog {
    protected FormToolkit toolkit;
    protected boolean useHtml = false;
    protected IContext context = new IContext.Context();
    protected Collection<NotificationRunnable> runnables = new LinkedList<NotificationRunnable>();
    protected Map<Integer, NotificationRunnable> mapForIds = new HashMap<Integer, NotificationRunnable>();
    protected ICompositeCreator creator = null;
    private String title;

    public PapyrusPopup(Shell parentShell, FormToolkit toolkit) {
        super(parentShell);
        this.toolkit = toolkit;
    }

    protected Control createDialogArea(Composite parent) {
        this.getShell().setText(this.title == null ? "" : this.title);
        this.getShell().setImage(PapyrusImageUtils.getDefaultIcon());
        Composite c = (Composite)super.createDialogArea(parent);
        c.setLayout((Layout)new FillLayout());
        this.createForm(c);
        return c;
    }

    protected void createForm(Composite c) {
        ScrolledForm form = this.toolkit.createScrolledForm(c);
        form.getBody().setLayout((Layout)new GridLayout());
        this.toolkit.decorateFormHeading(form.getForm());
        this.createSection(c, form);
        c.setLayoutData((Object)new GridData(1808));
    }

    public void setINotification(INotification notification) {
        this.context.put("notification_object_please_check_IContext_Constant", notification);
    }

    protected void createSection(Composite c, ScrolledForm form) {
        Section section = this.toolkit.createSection(form.getBody(), PapyrusToolkit.DEFAULT_STYLE);
        section.setText("Papyrus");
        if (this.creator != null && c instanceof Composite) {
            Composite createComposite = this.creator.createComposite((Composite)section, this.toolkit);
            section.setClient((Control)createComposite);
            this.context.put("composite_created_please_check_IContext_Constant", createComposite);
            this.getShell().setFocus();
        } else {
            section.setClient(this.doCreateContents((Composite)section));
            this.getShell().setFocus();
        }
        section.setLayoutData((Object)new GridData(1808));
    }

    public void addRunnable(NotificationRunnable runnable) {
        this.runnables.add(runnable);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.runnables != null && !this.runnables.isEmpty()) {
            int START_AFTER_CANCEL = 2;
            for (NotificationRunnable r : this.runnables) {
                this.createButton(parent, START_AFTER_CANCEL, r.getLabel(), START_AFTER_CANCEL == 2);
                this.mapForIds.put(START_AFTER_CANCEL, r);
                ++START_AFTER_CANCEL;
            }
        } else {
            this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        }
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId != 0 && buttonId != 1) {
            NotificationRunnable run = this.mapForIds.get(buttonId);
            if (run == null) {
                super.buttonPressed(buttonId);
            } else {
                run.run(this.context);
                Object contextCode = this.context.get("action_id");
                if (contextCode != null && contextCode instanceof Integer) {
                    this.setReturnCode((Integer)contextCode);
                }
            }
        } else {
            super.buttonPressed(buttonId);
        }
        this.close();
    }

    public void addRunnables(Collection<NotificationRunnable> runnable) {
        this.runnables.addAll(runnable);
    }

    protected abstract Control doCreateContents(Composite var1);

    public void setCompositeCreator(ICompositeCreator creator) {
        this.creator = creator;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public static Rectangle getBounds() {
        Display display = Display.getDefault();
        Rectangle bounds = display.getPrimaryMonitor().getBounds();
        Rectangle result = new Rectangle(bounds.x + bounds.width / 4, bounds.y + bounds.height / 4, bounds.width / 2, bounds.height / 2);
        return result;
    }

    protected Rectangle getConstrainedShellBounds(Rectangle preferredSize) {
        return super.getConstrainedShellBounds(preferredSize);
    }

    public void setUseHtml(boolean useHtml) {
        this.useHtml = useHtml;
    }

    public boolean isUseHtml() {
        return this.useHtml;
    }
}

