/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.menu.command;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.osgi.util.NLS;
import org.eclipse.papyrus.service.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.service.edit.service.IElementEditService;
import org.eclipse.papyrus.umlutils.NamedElementUtil;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.util.UMLUtil;

public class PasteElementCommand
extends AbstractCommand {
    protected ArrayList<EObject> eobjectTopaste = null;
    protected ArrayList<EObject> stereotypeApplicationTopaste = null;
    protected EObject targetOwner;
    protected ICommand command;
    protected String COPY_OF = "CopyOf";

    public PasteElementCommand(EditingDomain domain, EObject targetOwner) {
        if (domain.getClipboard() != null) {
            Collection rawData = domain.getClipboard();
            ArrayList<EObject> eobjectsTopaste = new ArrayList<EObject>();
            for (Object object : rawData) {
                if (!(object instanceof EObject)) continue;
                eobjectsTopaste.add((EObject)object);
            }
            Collection duplicatedObject = EcoreUtil.copyAll(eobjectsTopaste);
            Iterator iter = duplicatedObject.iterator();
            this.eobjectTopaste = new ArrayList();
            this.stereotypeApplicationTopaste = new ArrayList();
            while (iter.hasNext()) {
                EObject eObject = (EObject)iter.next();
                boolean isaUMLElement = false;
                if (eObject instanceof Element) {
                    isaUMLElement = true;
                }
                if (UMLUtil.getStereotype((EObject)eObject) == null && isaUMLElement) {
                    this.eobjectTopaste.add(eObject);
                    continue;
                }
                this.stereotypeApplicationTopaste.add(eObject);
            }
            this.targetOwner = targetOwner;
            MoveRequest moveRequest = new MoveRequest(targetOwner, this.eobjectTopaste);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)targetOwner);
            if (provider != null) {
                this.command = new CompositeCommand("Copy Object");
                this.command.compose((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)moveRequest));
            }
            int i = 0;
            while (i < this.eobjectTopaste.size()) {
                EObject element = this.eobjectTopaste.get(i);
                if (element instanceof NamedElement && domain instanceof TransactionalEditingDomain) {
                    String newName = NLS.bind((String)(String.valueOf(this.COPY_OF) + "_{0}_"), (Object)((NamedElement)element).getName());
                    String incrementedName = NamedElementUtil.getDefaultNameWithIncrementFromBase((String)newName, (Collection)targetOwner.eContents());
                    SetRequest renameRequest = new SetRequest((TransactionalEditingDomain)domain, element, (EStructuralFeature)UMLFactory.eINSTANCE.getUMLPackage().getNamedElement_Name(), (Object)incrementedName);
                    if (provider != null && this.command != null) {
                        this.command.compose((IUndoableOperation)provider.getEditCommand((IEditCommandRequest)renameRequest));
                    }
                }
                ++i;
            }
        }
    }

    public void execute() {
        if (this.command != null) {
            try {
                this.command.execute((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        for (EObject eObject : this.stereotypeApplicationTopaste) {
            this.targetOwner.eResource().getContents().add((Object)eObject);
        }
    }

    public boolean canExecute() {
        if (this.command == null) {
            return false;
        }
        return this.command.canExecute();
    }

    public void redo() {
        if (this.command != null) {
            try {
                this.command.redo((IProgressMonitor)new NullProgressMonitor(), null);
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
        for (EObject eObject : this.stereotypeApplicationTopaste) {
            this.targetOwner.eResource().getContents().add((Object)eObject);
        }
    }

    public void undo() {
        try {
            this.command.undo((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException executionException) {
            // empty catch block
        }
        for (EObject eObject : this.stereotypeApplicationTopaste) {
            this.targetOwner.eResource().getContents().remove((Object)eObject);
        }
    }
}

