/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelexplorer.widgets;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.papyrus.core.services.ServicesRegistry;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.modelexplorer.widgets.MetamodelContentProvider;
import org.eclipse.papyrus.resource.ModelSet;
import org.eclipse.papyrus.resource.ModelUtils;
import org.eclipse.papyrus.resource.uml.UmlModel;
import org.eclipse.papyrus.resource.uml.UmlUtils;
import org.eclipse.papyrus.uml.modelexplorer.widgets.Activator;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProfileContentProvider
extends MetamodelContentProvider {
    public Object[] getElements(Object inputElement) {
        Object[] parentElements = super.getElements(inputElement);
        LinkedList<Object> result = new LinkedList<Object>(Arrays.asList(parentElements));
        result.addAll(this.getAppliedProfile(inputElement));
        return result.toArray();
    }

    protected HashSet<Profile> getAppliedProfile(Object root) {
        HashSet<Profile> profileList = new HashSet<Profile>();
        if (root != null && root instanceof Package) {
            profileList.addAll((Collection<Profile>)((Package)root).getAllAppliedProfiles());
            return profileList;
        }
        ServicesRegistry servicesRegistry = EditorUtils.getMultiDiagramEditor().getServicesRegistry();
        if (servicesRegistry != null) {
            UmlModel umlModel = null;
            try {
                ModelSet modelSet = ModelUtils.getModelSetChecked((ServicesRegistry)servicesRegistry);
                umlModel = UmlUtils.getUmlModel((ModelSet)modelSet);
            }
            catch (Exception e) {
                Activator.log.error("Cannot succeed to access to modelSet by using service Registry", (Throwable)e);
            }
            if (umlModel == null) {
                return profileList;
            }
            EList contents = umlModel.getResource().getContents();
            for (EObject eObject : contents) {
                if (!(eObject instanceof Package)) continue;
                profileList.addAll((Collection<Profile>)((Package)eObject).getAllAppliedProfiles());
            }
        }
        return profileList;
    }
}

