/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelexplorer.widgets;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.modelexplorer.widgets.GraphicalModelExplorerBasedContentProvider;
import org.eclipse.papyrus.uml.modelexplorer.widgets.ProfileContentProvider;
import org.eclipse.papyrus.uml.modelexplorer.widgets.StereotypeContentProvider;
import org.eclipse.papyrus.uml.modelexplorer.widgets.StereotypeViewerFilter;
import org.eclipse.papyrus.uml.modelexplorer.widgets.UMLHierarchicViewerFilter;
import org.eclipse.papyrus.widgets.providers.IHierarchicContentProvider;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.util.UMLUtil;

public class UMLElementMEBContentProvider
extends GraphicalModelExplorerBasedContentProvider {
    public static final String UML_URI = "http://www.eclipse.org/uml2/3.0.0/UML";

    public UMLElementMEBContentProvider(EObject semanticRoot, String historyId) {
        super(semanticRoot, historyId);
    }

    public boolean isValidValue(Object element) {
        if (this.metaClassWanted != null) {
            EObject semanticObject = null;
            if (element instanceof IAdaptable) {
                semanticObject = (EObject)this.brige.getSemanticElement(element);
            }
            if (element instanceof EObject) {
                semanticObject = (EObject)element;
            }
            if (element instanceof EReference || semanticObject instanceof EReference) {
                return false;
            }
            if (semanticObject != null) {
                if (this.metaClassWanted instanceof EClass && ((EClass)this.metaClassWanted).isSuperTypeOf(semanticObject.eClass())) {
                    if (this.metaClassNotWantedList.size() > 0) {
                        for (Object notWanted : this.metaClassNotWantedList) {
                            if (!(notWanted instanceof EClass) || !((EClass)notWanted).isSuperTypeOf(semanticObject.eClass())) continue;
                            return false;
                        }
                    }
                    return true;
                }
                if (this.metaClassWanted instanceof Stereotype && semanticObject instanceof Element) {
                    Element selectedUMLelement = (Element)semanticObject;
                    return selectedUMLelement.getAppliedStereotypes().contains(this.metaClassWanted);
                }
                if (this.metaClassWanted instanceof EClass && !(this.metaClassWanted instanceof Element) && semanticObject instanceof Element) {
                    Element selectedUMLElement = (Element)semanticObject;
                    for (EObject stereotypeApplication : selectedUMLElement.getStereotypeApplications()) {
                        if (!((EClass)this.metaClassWanted).isInstance((Object)stereotypeApplication)) continue;
                        return true;
                    }
                }
            }
            return false;
        }
        return super.isValidValue(element);
    }

    public Object getAdaptedValue(Object selection) {
        selection = super.getAdaptedValue(selection);
        if (this.isStereotype() && selection instanceof Element) {
            Element element = (Element)selection;
            EObject stereotypeApplication = null;
            if (this.metaClassWanted instanceof Stereotype) {
                stereotypeApplication = element.getStereotypeApplication((Stereotype)this.metaClassWanted);
                if (stereotypeApplication == null) {
                    EList subStereotypes = element.getAppliedSubstereotypes((Stereotype)this.metaClassWanted);
                    for (Stereotype subSteretoype : subStereotypes) {
                        stereotypeApplication = element.getStereotypeApplication(subSteretoype);
                        if (stereotypeApplication == null) {
                            continue;
                        }
                        break;
                    }
                }
            } else {
                for (EObject appliedStereotype : element.getStereotypeApplications()) {
                    if (!((EClass)this.metaClassWanted).isInstance((Object)appliedStereotype)) continue;
                    stereotypeApplication = appliedStereotype;
                }
            }
            if (stereotypeApplication != null) {
                return stereotypeApplication;
            }
        }
        return selection;
    }

    public Object getContainerValue(Object selection) {
        Object semanticElement = selection;
        if (this.isStereotype() && selection instanceof EObject && selection instanceof EObject) {
            semanticElement = UMLUtil.getBaseElement((EObject)((EObject)selection));
        }
        return super.getContainerValue(semanticElement);
    }

    protected boolean isStereotype() {
        boolean isStereotype = this.metaClassWanted instanceof Stereotype;
        boolean isUMLElement = false;
        if (this.metaClassWanted instanceof EClass) {
            EClass eClass = (EClass)this.metaClassWanted;
            boolean bl = isUMLElement = eClass.getEAllSuperTypes().contains((Object)UMLPackage.eINSTANCE.getElement()) || eClass == UMLPackage.eINSTANCE.getElement();
        }
        return isStereotype || !isUMLElement;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        super.inputChanged(viewer, oldInput, newInput);
        if (this.viewer != null) {
            this.viewer.setFilters(new ViewerFilter[]{new UMLHierarchicViewerFilter((IHierarchicContentProvider)this)});
        }
    }

    protected IStructuredContentProvider getMetamodelContentProvider() {
        return new ProfileContentProvider();
    }

    protected IStructuredContentProvider getMetaclassContentProvider() {
        return new StereotypeContentProvider(this.metaClassWanted, this.metaClassNotWantedList);
    }

    protected ViewerFilter getMetaclassViewerFilter(Object selectedMetaClass) {
        return new StereotypeViewerFilter(selectedMetaClass);
    }
}

