/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelexplorer.widgets;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.papyrus.core.services.ServicesRegistry;
import org.eclipse.papyrus.core.utils.EditorUtils;
import org.eclipse.papyrus.modelexplorer.widgets.AdvancedMETreeDialog;
import org.eclipse.papyrus.modelexplorer.widgets.EclassComparator;
import org.eclipse.papyrus.modelexplorer.widgets.MetaclassLabelProvider;
import org.eclipse.papyrus.resource.ModelSet;
import org.eclipse.papyrus.resource.ModelUtils;
import org.eclipse.papyrus.resource.uml.UmlModel;
import org.eclipse.papyrus.resource.uml.UmlUtils;
import org.eclipse.papyrus.uml.modelexplorer.widgets.Activator;
import org.eclipse.papyrus.uml.modelexplorer.widgets.NamedElementComparator;
import org.eclipse.papyrus.uml.modelexplorer.widgets.ServiceEditFilteredUMLContentProvider;
import org.eclipse.papyrus.uml.modelexplorer.widgets.StereotypeMetaclassLabelProvider;
import org.eclipse.papyrus.uml.modelexplorer.widgets.UMLHierarchicViewerFilter;
import org.eclipse.papyrus.widgets.providers.IHierarchicContentProvider;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.uml2.uml.Package;
import org.eclipse.uml2.uml.Profile;
import org.eclipse.uml2.uml.UMLPackage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class UMLTreeSelectorDialog
extends AdvancedMETreeDialog {
    protected static final String UML = "UML";
    protected HashSet<Profile> appliedProfiles = null;
    protected Combo comboMetamodel;

    public UMLTreeSelectorDialog(Shell parentShell, EObject editedEObject, EStructuralFeature feature, EObject root, EClass wantedEClass, List<Object> metaClassNotWanted) {
        super(parentShell, root, (Object)wantedEClass, metaClassNotWanted, (EPackage)UMLPackage.eINSTANCE);
        this.init(editedEObject, feature, root, wantedEClass, metaClassNotWanted);
    }

    public UMLTreeSelectorDialog(Shell parentShell) {
        super(parentShell, (EPackage)UMLPackage.eINSTANCE);
    }

    public void init(EObject editedEObject, EStructuralFeature feature, EObject root, EClass wantedEClass, List<Object> metaClassNotWanted) {
        super.init(root, (Object)wantedEClass, metaClassNotWanted);
        this.contentProvider = new ServiceEditFilteredUMLContentProvider(editedEObject, feature, root);
        this.contentProvider.setMetaClassWanted((Object)wantedEClass);
        this.contentProvider.setMetaClassNotWanted(metaClassNotWanted);
        this.appliedProfiles = this.getAppliedProfile();
    }

    public void create() {
        super.create();
        Label metamodelLabel = new Label(this.getDialogArea(), 64);
        metamodelLabel.setText("Metamodel:");
        this.comboMetamodel = new Combo(this.getDialogArea(), 0);
        this.comboMetamodel.setLayoutData((Object)new GridData(4, 4, true, false));
        final ArrayList<Profile> profiles = new ArrayList<Profile>();
        profiles.addAll(this.appliedProfiles);
        Collections.sort(profiles, new NamedElementComparator());
        for (Profile profile : profiles) {
            this.comboMetamodel.add(profile.getQualifiedName());
        }
        this.comboMetamodel.add(UML);
        this.comboMetamodel.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                int index = UMLTreeSelectorDialog.this.comboMetamodel.getSelectionIndex();
                if (UMLTreeSelectorDialog.this.comboMetamodel.getItem(index).equals(UMLTreeSelectorDialog.UML)) {
                    UMLTreeSelectorDialog.this.fillmetaclassList((EPackage)UMLPackage.eINSTANCE);
                    UMLTreeSelectorDialog.this.setMetaclassLabelProvider((LabelProvider)new MetaclassLabelProvider());
                    UMLTreeSelectorDialog.this.fillMetaclassCombo(UMLTreeSelectorDialog.this.metaclasses, (Comparator)new EclassComparator());
                } else {
                    Profile selectedProfile = (Profile)profiles.get(index);
                    ArrayList stereotypesList = new ArrayList(selectedProfile.getOwnedStereotypes());
                    UMLTreeSelectorDialog.this.setMetaclassLabelProvider((LabelProvider)new StereotypeMetaclassLabelProvider());
                    UMLTreeSelectorDialog.this.fillMetaclassCombo(stereotypesList, new NamedElementComparator());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        ViewerFilter[] filters = new ViewerFilter[]{new UMLHierarchicViewerFilter((IHierarchicContentProvider)this.contentProvider)};
        this.getViewer().setFilters(filters);
        this.getShell().pack();
    }

    protected HashSet<Profile> getAppliedProfile() {
        HashSet<Profile> profileList = new HashSet<Profile>();
        if (this.root != null && this.root instanceof Package) {
            profileList.addAll((Collection<Profile>)((Package)this.root).getAllAppliedProfiles());
            return profileList;
        }
        ServicesRegistry servicesRegistry = EditorUtils.getMultiDiagramEditor().getServicesRegistry();
        if (servicesRegistry != null) {
            UmlModel umlModel = null;
            try {
                ModelSet modelSet = ModelUtils.getModelSetChecked((ServicesRegistry)servicesRegistry);
                umlModel = UmlUtils.getUmlModel((ModelSet)modelSet);
            }
            catch (Exception e) {
                Activator.log.error("Cannot succeed to access to modelSet by using service Registry", (Throwable)e);
            }
            if (umlModel == null) {
                return profileList;
            }
            EList contents = umlModel.getResource().getContents();
            for (EObject eObject : contents) {
                if (!(eObject instanceof Package)) continue;
                profileList.addAll((Collection<Profile>)((Package)eObject).getAllAppliedProfiles());
            }
        }
        return profileList;
    }
}

