/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.modelexplorer.handler;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.facet.infra.browser.uicore.internal.model.LinkItem;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.papyrus.core.services.ServiceException;
import org.eclipse.papyrus.core.utils.BusinessModelResolver;
import org.eclipse.papyrus.core.utils.ServiceUtilsForActionHandlers;
import org.eclipse.papyrus.modelexplorer.CommandContext;
import org.eclipse.papyrus.modelexplorer.ICommandContext;
import org.eclipse.papyrus.uml.modelexplorer.Activator;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractCommandHandler
extends AbstractHandler {
    protected abstract Command getCommand();

    @Deprecated
    protected EObject getSelectedElement() {
        Object selection;
        EObject eObject = null;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelection iSelection = selection = activeWorkbenchWindow != null ? activeWorkbenchWindow.getSelectionService().getSelection() : null;
        if (selection != null) {
            Object businessObject;
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                selection = structuredSelection.getFirstElement();
            }
            if (selection instanceof IAdaptable) {
                selection = ((IAdaptable)selection).getAdapter(EObject.class);
            }
            if ((businessObject = BusinessModelResolver.getInstance().getBusinessModel(selection)) instanceof EObject) {
                eObject = (EObject)businessObject;
            }
        }
        return eObject;
    }

    @Deprecated
    protected List<EObject> getSelectedElements() {
        ISelection selection;
        ArrayList<EObject> selectedEObjects = new ArrayList<EObject>();
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelection iSelection = selection = activeWorkbenchWindow != null ? activeWorkbenchWindow.getSelectionService().getSelection() : null;
        if (selection != null) {
            if (selection instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)selection;
                Object[] objectArray = structuredSelection.toArray();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object current = objectArray[n2];
                    if (current instanceof IAdaptable) {
                        selectedEObjects.add((EObject)((IAdaptable)current).getAdapter(EObject.class));
                    }
                    ++n2;
                }
            } else if (selection instanceof IAdaptable) {
                selectedEObjects.add((EObject)((IAdaptable)selection).getAdapter(EObject.class));
            }
        }
        return selectedEObjects;
    }

    protected ICommandContext getCommandContext() {
        Object selection;
        IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        ISelection iSelection = selection = activeWorkbenchWindow != null ? activeWorkbenchWindow.getSelectionService().getSelection() : null;
        if (selection == null) {
            return null;
        }
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection structuredSelection = (IStructuredSelection)selection;
            selection = structuredSelection.getFirstElement();
        }
        EObject container = null;
        EReference reference = null;
        if (selection instanceof IAdaptable && (container = (EObject)((IAdaptable)selection).getAdapter(EObject.class)) == null && (reference = (EReference)((IAdaptable)selection).getAdapter(EReference.class)) != null && selection instanceof LinkItem) {
            container = ((LinkItem)selection).getParent();
        }
        CommandContext context = null;
        if (container != null) {
            context = reference != null ? new CommandContext(container, reference) : new CommandContext(container);
        }
        return context;
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Command creationcommand = null;
        try {
            ServiceUtilsForActionHandlers util = new ServiceUtilsForActionHandlers();
            creationcommand = this.getCommand();
            util.getTransactionalEditingDomain().getCommandStack().execute(creationcommand);
            return creationcommand.getResult();
        }
        catch (ServiceException e) {
            Activator.log.error("Unexpected error while executing command.", (Throwable)e);
            return null;
        }
    }

    public boolean isEnabled() {
        return this.getCommand().canExecute();
    }

    public boolean isVisible() {
        return this.getCommand().canExecute();
    }
}

