/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.command;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.type.core.commands.EditElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.notation.Edge;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;

public class ConnectorReorientCommand
extends EditElementCommand {
    private final int reorientDirection;
    private final EObject oldEnd;
    private final EObject newEnd;
    private final View newEndView;
    private final Edge reorientedEdgeView;

    public ConnectorReorientCommand(ReorientRelationshipRequest request) {
        super(request.getLabel(), request.getRelationship(), (IEditCommandRequest)request);
        this.reorientDirection = request.getDirection();
        this.oldEnd = request.getOldRelationshipEnd();
        this.newEnd = request.getNewRelationshipEnd();
        this.newEndView = (View)request.getParameter("RECONNECT_END_VIEW");
        this.reorientedEdgeView = (Edge)request.getParameter("graphical_edge");
    }

    public boolean canExecute() {
        if (!(this.getElementToEdit() instanceof Connector)) {
            return false;
        }
        if (this.getLink().getEnds().size() != 2) {
            return false;
        }
        if (this.reorientDirection == 1) {
            return this.canReorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.canReorientTarget();
        }
        return false;
    }

    protected boolean canReorientSource() {
        if (!(this.getNewSource() instanceof ConnectableElement)) {
            return false;
        }
        if (this.reorientedEdgeView.getTarget() != null && this.newEndView != null) {
            if (this.reorientedEdgeView.getTarget() == this.newEndView) {
                return false;
            }
            if (this.reorientedEdgeView.getTarget().getChildren().contains((Object)this.newEndView) || this.newEndView.getChildren().contains((Object)this.reorientedEdgeView.getTarget())) {
                return false;
            }
        }
        return this.deduceContainer(this.reorientedEdgeView.getTarget(), this.newEndView) != null;
    }

    protected boolean canReorientTarget() {
        if (!(this.getNewTarget() instanceof ConnectableElement)) {
            return false;
        }
        if (this.reorientedEdgeView.getSource() != null && this.newEndView != null) {
            if (this.reorientedEdgeView.getSource() == this.newEndView) {
                return false;
            }
            if (this.reorientedEdgeView.getSource().getChildren().contains((Object)this.newEndView) || this.newEndView.getChildren().contains((Object)this.reorientedEdgeView.getSource())) {
                return false;
            }
        }
        return this.deduceContainer(this.reorientedEdgeView.getSource(), this.newEndView) != null;
    }

    protected CommandResult doExecuteWithResult(IProgressMonitor monitor, IAdaptable info) throws ExecutionException {
        if (!this.canExecute()) {
            throw new ExecutionException("Invalid arguments in reorient link command");
        }
        if (this.reorientDirection == 1) {
            return this.reorientSource();
        }
        if (this.reorientDirection == 2) {
            return this.reorientTarget();
        }
        throw new IllegalStateException();
    }

    protected CommandResult reorientSource() throws ExecutionException {
        ConnectorEnd reorientedEnd = (ConnectorEnd)this.getLink().getEnds().get(0);
        return this.reorientEnd(reorientedEnd, (ConnectableElement)this.getNewSource(), this.getNewPartWithPort());
    }

    protected CommandResult reorientTarget() throws ExecutionException {
        ConnectorEnd reorientedEnd = (ConnectorEnd)this.getLink().getEnds().get(1);
        return this.reorientEnd(reorientedEnd, (ConnectableElement)this.getNewTarget(), this.getNewPartWithPort());
    }

    private CommandResult reorientEnd(ConnectorEnd end, ConnectableElement role, Property partWithPort) throws ExecutionException {
        end.setRole(role);
        end.setPartWithPort(partWithPort);
        return CommandResult.newOKCommandResult();
    }

    protected Connector getLink() {
        return (Connector)this.getElementToEdit();
    }

    protected Element getOldSource() {
        return (Element)this.oldEnd;
    }

    protected Element getNewSource() {
        return (Element)this.newEnd;
    }

    protected Element getOldTarget() {
        return (Element)this.oldEnd;
    }

    protected Element getNewTarget() {
        return (Element)this.newEnd;
    }

    protected Element getNewEndParent() {
        EObject parent = ViewUtil.getContainerView((View)this.newEndView).getElement();
        return parent instanceof Element ? (Element)parent : null;
    }

    private Property getNewPartWithPort() {
        Property partWithPort = null;
        Element newEndParent = this.getNewEndParent();
        if (newEndParent != null && newEndParent instanceof Property && !(newEndParent instanceof Port)) {
            partWithPort = (Property)newEndParent;
        }
        return partWithPort;
    }

    private StructuredClassifier deduceContainer(View source, View target) {
        StructuredClassifier containerProposedBySource = this.proposedContainer(source);
        StructuredClassifier containerProposedByTarget = this.proposedContainer(target);
        StructuredClassifier deducedContainer = null;
        if (containerProposedBySource != null && containerProposedByTarget != null && containerProposedBySource == containerProposedByTarget) {
            deducedContainer = containerProposedBySource;
        }
        return deducedContainer;
    }

    private StructuredClassifier proposedContainer(View view) {
        View currentView = view;
        while (currentView != null) {
            EObject semanticElement = currentView.getElement();
            if (semanticElement instanceof StructuredClassifier) {
                return (StructuredClassifier)semanticElement;
            }
            currentView = ViewUtil.getContainerView((View)currentView);
        }
        return null;
    }
}

