/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper;

import java.util.Arrays;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateRelationshipCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.papyrus.uml.service.types.command.AssociationReorientCommand;
import org.eclipse.papyrus.uml.service.types.helper.ElementEditHelper;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.UMLPackage;

public class AssociationBaseEditHelper
extends ElementEditHelper {
    protected ICommand getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        return new AssociationReorientCommand(req);
    }

    private Classifier getSourceOwnerType(ConfigureRequest req) {
        Classifier result = null;
        Object paramObject = req.getParameter("CreateRelationshipRequest.source");
        if (paramObject instanceof Classifier) {
            result = (Classifier)paramObject;
        }
        return result;
    }

    private Classifier getTargetOwnerType(ConfigureRequest req) {
        Classifier result = null;
        Object paramObject = req.getParameter("CreateRelationshipRequest.target");
        if (paramObject instanceof Classifier) {
            result = (Classifier)paramObject;
        }
        return result;
    }

    protected boolean canCreate(EObject source, EObject target) {
        if (source != null && !(source instanceof Classifier)) {
            return false;
        }
        return target == null || target instanceof Classifier;
    }

    protected ICommand getCreateRelationshipCommand(CreateRelationshipRequest req) {
        boolean noSourceAndTarget;
        EObject source = req.getSource();
        EObject target = req.getTarget();
        boolean noSourceOrTarget = source == null || target == null;
        boolean bl = noSourceAndTarget = source == null && target == null;
        if (!noSourceAndTarget && !this.canCreate(source, target)) {
            return UnexecutableCommand.INSTANCE;
        }
        if (noSourceOrTarget && !noSourceAndTarget) {
            return IdentityCommand.INSTANCE;
        }
        EObject proposedContainer = EMFCoreUtil.getLeastCommonContainer(Arrays.asList(source, target), (EClass)UMLPackage.eINSTANCE.getPackage());
        req.setContainer(proposedContainer);
        return new CreateRelationshipCommand(req);
    }

    protected ICommand getConfigureCommand(ConfigureRequest req) {
        if (this.getSourceOwnerType(req) == null || this.getTargetOwnerType(req) == null) {
            return UnexecutableCommand.INSTANCE;
        }
        return super.getConfigureCommand(req);
    }
}

