/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper;

import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.common.core.command.IdentityCommand;
import org.eclipse.gmf.runtime.common.core.command.UnexecutableCommand;
import org.eclipse.gmf.runtime.diagram.core.util.ViewUtil;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.CreateRelationshipCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.CreateRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.notation.View;
import org.eclipse.papyrus.uml.service.types.command.ConnectorReorientCommand;
import org.eclipse.papyrus.uml.service.types.helper.ElementEditHelper;
import org.eclipse.uml2.uml.ConnectableElement;
import org.eclipse.uml2.uml.Connector;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.StructuredClassifier;
import org.eclipse.uml2.uml.UMLFactory;

public class ConnectorEditHelper
extends ElementEditHelper {
    protected ICommand getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        return new ConnectorReorientCommand(req);
    }

    protected boolean canCreate(EObject source, EObject target, View sourceView, View targetView) {
        if (source != null && !(source instanceof ConnectableElement)) {
            return false;
        }
        if (target != null && !(target instanceof ConnectableElement)) {
            return false;
        }
        if (sourceView != null && targetView != null) {
            if (sourceView == targetView) {
                return false;
            }
            if (sourceView.getChildren().contains((Object)targetView) || targetView.getChildren().contains((Object)sourceView)) {
                return false;
            }
        }
        return true;
    }

    protected ICommand getCreateRelationshipCommand(CreateRelationshipRequest req) {
        boolean noSourceAndTarget;
        EObject source = req.getSource();
        EObject target = req.getTarget();
        boolean noSourceOrTarget = source == null || target == null;
        boolean bl = noSourceAndTarget = source == null && target == null;
        if (!noSourceAndTarget && !this.canCreate(source, target, this.getSourceView((IEditCommandRequest)req), this.getTargetView((IEditCommandRequest)req))) {
            return UnexecutableCommand.INSTANCE;
        }
        if (noSourceOrTarget && !noSourceAndTarget) {
            return IdentityCommand.INSTANCE;
        }
        StructuredClassifier proposedContainer = this.deduceContainer(this.getSourceView((IEditCommandRequest)req), this.getTargetView((IEditCommandRequest)req));
        if (proposedContainer == null) {
            return UnexecutableCommand.INSTANCE;
        }
        req.setContainer((EObject)proposedContainer);
        return new CreateRelationshipCommand(req);
    }

    private ConnectableElement getSourceRole(IEditCommandRequest req) {
        ConnectableElement result = null;
        Object paramObject = req.getParameter("CreateRelationshipRequest.source");
        if (paramObject instanceof ConnectableElement) {
            result = (ConnectableElement)paramObject;
        }
        return result;
    }

    private ConnectableElement getTargetRole(IEditCommandRequest req) {
        ConnectableElement result = null;
        Object paramObject = req.getParameter("CreateRelationshipRequest.target");
        if (paramObject instanceof ConnectableElement) {
            result = (ConnectableElement)paramObject;
        }
        return result;
    }

    private Property getSourcePartWithPort(IEditCommandRequest req) {
        Property result = null;
        View parentView = ViewUtil.getContainerView((View)this.getSourceView(req));
        EObject semanticParent = parentView.getElement();
        if (semanticParent instanceof Property && !(semanticParent instanceof Port)) {
            result = (Property)semanticParent;
        }
        return result;
    }

    private Property getTargetPartWithPort(IEditCommandRequest req) {
        Property result = null;
        View parentView = ViewUtil.getContainerView((View)this.getTargetView(req));
        EObject semanticParent = parentView.getElement();
        if (semanticParent instanceof Property && !(semanticParent instanceof Port)) {
            result = (Property)semanticParent;
        }
        return result;
    }

    private View getSourceView(IEditCommandRequest req) {
        return (View)req.getParameter("SOURCE_GRAPHICAL_VIEW");
    }

    private View getTargetView(IEditCommandRequest req) {
        return (View)req.getParameter("TARGET_GRAPHICAL_VIEW");
    }

    protected ICommand getConfigureCommand(ConfigureRequest req) {
        Connector connector = (Connector)req.getElementToConfigure();
        ConnectableElement sourceRole = this.getSourceRole((IEditCommandRequest)req);
        ConnectableElement targetRole = this.getTargetRole((IEditCommandRequest)req);
        Property sourcePartWithPort = this.getSourcePartWithPort((IEditCommandRequest)req);
        Property targetPartWithPort = this.getTargetPartWithPort((IEditCommandRequest)req);
        ConfigureElementCommand configureCommand = new ConfigureElementCommand(req){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                if (sourceRole == null || targetRole == null) {
                    return CommandResult.newCancelledCommandResult();
                }
                ConnectorEnd sourceEnd = UMLFactory.eINSTANCE.createConnectorEnd();
                sourceEnd.setLower(1);
                sourceEnd.setUpper(1);
                sourceEnd.setRole(sourceRole);
                sourceEnd.setPartWithPort(sourcePartWithPort);
                ConnectorEnd targetEnd = UMLFactory.eINSTANCE.createConnectorEnd();
                targetEnd.setLower(1);
                targetEnd.setUpper(1);
                targetEnd.setRole(targetRole);
                targetEnd.setPartWithPort(targetPartWithPort);
                connector.getEnds().add((Object)sourceEnd);
                connector.getEnds().add((Object)targetEnd);
                return CommandResult.newOKCommandResult((Object)connector);
            }
        };
        return CompositeCommand.compose((ICommand)configureCommand, (ICommand)super.getConfigureCommand(req));
    }

    private StructuredClassifier deduceContainer(View source, View target) {
        StructuredClassifier containerProposedBySource = this.proposedContainer(source);
        StructuredClassifier containerProposedByTarget = this.proposedContainer(target);
        StructuredClassifier deducedContainer = null;
        if (containerProposedBySource != null && containerProposedByTarget != null && containerProposedBySource == containerProposedByTarget) {
            deducedContainer = containerProposedBySource;
        }
        return deducedContainer;
    }

    private StructuredClassifier proposedContainer(View view) {
        View currentView = view;
        while (currentView != null) {
            EObject semanticElement = currentView.getElement();
            if (semanticElement instanceof StructuredClassifier) {
                return (StructuredClassifier)semanticElement;
            }
            currentView = ViewUtil.getContainerView((View)currentView);
        }
        return null;
    }
}

