/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper;

import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyReferenceRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.SetRequest;
import org.eclipse.papyrus.service.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.service.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.service.types.command.DependencyReorientCommand;
import org.eclipse.papyrus.uml.service.types.helper.DirectedRelationshipEditHelper;
import org.eclipse.uml2.uml.Dependency;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.UMLPackage;

public class DependencyEditHelper
extends DirectedRelationshipEditHelper {
    protected EReference getSourceReference() {
        return UMLPackage.eINSTANCE.getDependency_Client();
    }

    protected EReference getTargetReference() {
        return UMLPackage.eINSTANCE.getDependency_Supplier();
    }

    protected boolean canCreate(EObject source, EObject target) {
        if (source != null && !(source instanceof NamedElement)) {
            return false;
        }
        return target == null || target instanceof NamedElement;
    }

    protected ICommand getReorientRelationshipCommand(ReorientRelationshipRequest req) {
        return new DependencyReorientCommand(req);
    }

    protected ICommand getDestroyReferenceCommand(DestroyReferenceRequest req) {
        ICommand command = super.getDestroyReferenceCommand(req);
        Dependency elementToEdit = (Dependency)req.getContainer();
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)elementToEdit.eContainer());
        if (provider == null) {
            return command;
        }
        boolean shouldDestroyDependency = false;
        if (this.getSourceReference().equals(req.getContainingFeature()) && elementToEdit.getClients().size() == 1) {
            shouldDestroyDependency = true;
        }
        if (this.getTargetReference().equals(req.getContainingFeature()) && elementToEdit.getSuppliers().size() == 1) {
            shouldDestroyDependency = true;
        }
        if (shouldDestroyDependency) {
            DestroyElementRequest destroyRequest = new DestroyElementRequest((EObject)elementToEdit, false);
            command = provider.getEditCommand((IEditCommandRequest)destroyRequest);
        }
        return command;
    }

    protected ICommand getSetCommand(SetRequest req) {
        IElementEditService provider;
        Object values;
        if ((this.getSourceReference().equals(req.getFeature()) || this.getTargetReference().equals(req.getFeature())) && (values = req.getValue()) != null && values instanceof EList && ((EList)values).isEmpty() && (provider = ElementEditServiceUtils.getCommandProvider((Object)req.getElementToEdit())) != null) {
            DestroyElementRequest destroyRequest = new DestroyElementRequest(req.getElementToEdit(), false);
            ICommand destroyCommand = provider.getEditCommand((IEditCommandRequest)destroyRequest);
            return destroyCommand;
        }
        return super.getSetCommand(req);
    }
}

