/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper;

import java.util.HashSet;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.DestroyElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.papyrus.uml.service.types.helper.ElementEditHelper;
import org.eclipse.uml2.uml.ActivityEdge;
import org.eclipse.uml2.uml.Pin;

public class PinEditHelper
extends ElementEditHelper {
    protected ICommand getDestroyElementCommand(DestroyElementRequest req) {
        ICommand cmd = this.getBasicDestroyElementCommand(req);
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(req.getEditingDomain(), "Destroy Pin Command");
        if (cmd != null && cmd.canExecute()) {
            cc.compose((IUndoableOperation)cmd);
        }
        cc.compose((IUndoableOperation)cmd);
        EObject pin_ = req.getElementToDestroy();
        if (pin_ instanceof Pin) {
            HashSet<ActivityEdge> edgesToDestroy = new HashSet<ActivityEdge>();
            Pin pin = (Pin)pin_;
            for (ActivityEdge activityEdge : pin.getIncomings()) {
                if (activityEdge == null) continue;
                edgesToDestroy.add(activityEdge);
            }
            for (ActivityEdge activityEdge : pin.getOutgoings()) {
                if (activityEdge == null) continue;
                edgesToDestroy.add(activityEdge);
            }
            for (ActivityEdge edgeToDstroy : edgesToDestroy) {
                DestroyElementCommand destroyCommand = new DestroyElementCommand(new DestroyElementRequest(req.getEditingDomain(), (EObject)edgeToDstroy, false));
                if (destroyCommand == null || !destroyCommand.canExecute()) continue;
                cc.compose((IUndoableOperation)destroyCommand);
            }
        }
        return cc;
    }
}

