/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.gmf.runtime.common.core.command.CompositeCommand;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.core.util.EMFCoreUtil;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyElementRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.IEditCommandRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.MoveRequest;
import org.eclipse.gmf.runtime.emf.type.core.requests.ReorientRelationshipRequest;
import org.eclipse.papyrus.service.edit.service.ElementEditServiceUtils;
import org.eclipse.papyrus.service.edit.service.IElementEditService;
import org.eclipse.papyrus.uml.service.types.utils.ElementUtil;
import org.eclipse.uml2.uml.Association;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.ConnectorEnd;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Port;
import org.eclipse.uml2.uml.Property;
import org.eclipse.uml2.uml.UMLPackage;

public class ClassifierHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request) {
        ArrayList<Association> dependents = new ArrayList<Association>();
        if (request.getElementToDestroy() instanceof Classifier) {
            Classifier classifierToDelete = (Classifier)request.getElementToDestroy();
            dependents.addAll((Collection<Association>)classifierToDelete.getSourceDirectedRelationships(UMLPackage.eINSTANCE.getGeneralization()));
            dependents.addAll((Collection<Association>)classifierToDelete.getTargetDirectedRelationships(UMLPackage.eINSTANCE.getGeneralization()));
            for (Association association : classifierToDelete.getAssociations()) {
                for (Property end : association.getMemberEnds()) {
                    if (end.getType() != classifierToDelete) continue;
                    dependents.add(association);
                }
            }
        }
        if (!dependents.isEmpty()) {
            return request.getDestroyDependentsCommand(dependents);
        }
        return null;
    }

    protected ICommand getBeforeMoveCommand(MoveRequest request) {
        ICommand gmfCommand = super.getBeforeMoveCommand(request);
        for (Object movedObject : request.getElementsToMove().keySet()) {
            if (!(movedObject instanceof Property) || movedObject instanceof Port) continue;
            Property movedProperty = (Property)movedObject;
            EReference[] refs = new EReference[]{UMLPackage.eINSTANCE.getConnectorEnd_PartWithPort(), UMLPackage.eINSTANCE.getConnectorEnd_Role()};
            Collection referencers = EMFCoreUtil.getReferencers((EObject)movedProperty, (EReference[])refs);
            IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)movedProperty);
            if (provider == null) continue;
            for (ConnectorEnd end : referencers) {
                DestroyElementRequest req = new DestroyElementRequest((EObject)end, false);
                ICommand deleteCommand = provider.getEditCommand((IEditCommandRequest)req);
                gmfCommand = CompositeCommand.compose((ICommand)gmfCommand, (ICommand)deleteCommand);
            }
        }
        List<EObject> currentlyRefactoredElements = request.getParameter("ASSOCIATION_REFACTORED_ELEMENTS") != null ? (List)request.getParameter("ASSOCIATION_REFACTORED_ELEMENTS") : new ArrayList();
        for (Object movedObject : request.getElementsToMove().keySet()) {
            if (!(movedObject instanceof Property) || movedObject instanceof Port) continue;
            Property movedProperty = (Property)movedObject;
            Association relatedAssociation = movedProperty.getAssociation();
            if (movedProperty.getAssociation() == null || !ElementUtil.hasNature((Element)movedProperty.getAssociation(), "UML_Nature") || movedProperty.eContainer() == request.getTargetContainer() && movedProperty.eContainingFeature() == request.getTargetFeature((EObject)movedProperty) || currentlyRefactoredElements.contains(movedObject) || currentlyRefactoredElements.contains(relatedAssociation)) continue;
            currentlyRefactoredElements.add((EObject)movedObject);
            request.getParameters().put("ASSOCIATION_REFACTORED_ELEMENTS", currentlyRefactoredElements);
            ICommand refactorCommand = this.getAssociationRefactoringCommand(movedProperty, relatedAssociation, request);
            gmfCommand = CompositeCommand.compose((ICommand)gmfCommand, (ICommand)refactorCommand);
        }
        if (gmfCommand != null) {
            gmfCommand = gmfCommand.reduce();
        }
        return gmfCommand;
    }

    private ICommand getAssociationRefactoringCommand(Property movedProperty, Association associationToRefactor, MoveRequest request) {
        Association relatedAssociation = movedProperty.getAssociation();
        int direction = 2;
        if (movedProperty == associationToRefactor.getMemberEnds().get(0)) {
            direction = 1;
        }
        ReorientRelationshipRequest reorientRequest = new ReorientRelationshipRequest((EObject)relatedAssociation, request.getTargetContainer(), movedProperty.eContainer(), direction);
        reorientRequest.addParameters(request.getParameters());
        IElementEditService provider = ElementEditServiceUtils.getCommandProvider((Object)relatedAssociation);
        if (provider != null) {
            return provider.getEditCommand((IEditCommandRequest)reorientRequest);
        }
        return null;
    }
}

