/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import java.util.ArrayList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.edithelper.AbstractEditHelperAdvice;
import org.eclipse.gmf.runtime.emf.type.core.requests.DestroyDependentsRequest;
import org.eclipse.papyrus.core.utils.PapyrusEcoreUtils;
import org.eclipse.uml2.uml.ExecutionSpecification;
import org.eclipse.uml2.uml.InteractionFragment;
import org.eclipse.uml2.uml.Lifeline;
import org.eclipse.uml2.uml.MessageOccurrenceSpecification;
import org.eclipse.uml2.uml.OccurrenceSpecification;
import org.eclipse.uml2.uml.PartDecomposition;

public class LifelineHelperAdvice
extends AbstractEditHelperAdvice {
    protected ICommand getBeforeDestroyDependentsCommand(DestroyDependentsRequest request) {
        ArrayList<Object> dependentsToDestroy = new ArrayList<Object>();
        Lifeline lifeline = (Lifeline)request.getElementToDestroy();
        for (InteractionFragment ift : lifeline.getCoveredBys()) {
            if (ift instanceof ExecutionSpecification) {
                dependentsToDestroy.add(ift);
            }
            if (ift instanceof MessageOccurrenceSpecification) {
                dependentsToDestroy.add(((MessageOccurrenceSpecification)ift).getMessage());
            }
            if (!(ift instanceof OccurrenceSpecification)) continue;
            dependentsToDestroy.add(ift);
        }
        PartDecomposition decomposition = lifeline.getDecomposedAs();
        if (decomposition != null && PapyrusEcoreUtils.isOnlyUsage((EObject)decomposition, (EObject)lifeline)) {
            dependentsToDestroy.add(decomposition);
        }
        if (!dependentsToDestroy.isEmpty()) {
            return request.getDestroyDependentsCommand(dependentsToDestroy);
        }
        return null;
    }
}

