/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.uml.service.types.helper.advice;

import java.util.Collection;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.gmf.runtime.common.core.command.CommandResult;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.emf.type.core.commands.ConfigureElementCommand;
import org.eclipse.gmf.runtime.emf.type.core.requests.ConfigureRequest;
import org.eclipse.papyrus.uml.service.types.helper.advice.AbstractStereotypedElementEditHelperAdvice;
import org.eclipse.papyrus.uml.service.types.utils.NamedElementHelper;
import org.eclipse.papyrus.uml.standard.StandardPackage;
import org.eclipse.papyrus.uml.standard.util.StandardResource;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;

public class TraceEditHelperAdvice
extends AbstractStereotypedElementEditHelperAdvice {
    public TraceEditHelperAdvice() {
        this.requiredProfileIDs.add(StandardResource.STANDARD_ID);
    }

    protected ICommand getBeforeConfigureCommand(ConfigureRequest request) {
        return new ConfigureElementCommand(request){

            protected CommandResult doExecuteWithResult(IProgressMonitor progressMonitor, IAdaptable info) throws ExecutionException {
                NamedElement element = (NamedElement)request.getElementToConfigure();
                if (element != null) {
                    Stereotype stereotypeToApply = element.getApplicableStereotype(StandardResource.TRACE_ID);
                    if (stereotypeToApply != null) {
                        element.applyStereotype(stereotypeToApply);
                    }
                    String initializedName = NamedElementHelper.getDefaultNameWithIncrementFromBase(StandardPackage.eINSTANCE.getTrace().getName(), (Collection)element.eContainer().eContents());
                    element.setName(initializedName);
                }
                return CommandResult.newOKCommandResult((Object)element);
            }
        };
    }
}

