/*****************************************************************************
 * Copyright (c) 2009 CEA LIST.
 *
 *    
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *  Yann Tanguy (CEA LIST) yann.tanguy@cea.fr - Initial API and implementation
 *
 *****************************************************************************/
package org.eclipse.papyrus.uml.standard.provider;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.provider.ChangeNotifier;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.IDisposable;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.papyrus.uml.standard.util.StandardAdapterFactory;

/**
 * This is the factory that is used to provide the interfaces needed to support Viewers.
 * The adapters generated by this factory convert EMF adapter notifications into calls to {@link #fireNotifyChanged fireNotifyChanged}.
 * The adapters also support Eclipse property sheets.
 * Note that most of the adapters are shared among multiple instances.
 * <!-- begin-user-doc --> <!--
 * end-user-doc -->
 * 
 * @generated
 */
public class StandardItemProviderAdapterFactory extends StandardAdapterFactory implements ComposeableAdapterFactory, IChangeNotifier, IDisposable {

	/**
	 * This keeps track of the root adapter factory that delegates to this adapter factory. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ComposedAdapterFactory parentAdapterFactory;

	/**
	 * This is used to implement {@link org.eclipse.emf.edit.provider.IChangeNotifier}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected IChangeNotifier changeNotifier = new ChangeNotifier();

	/**
	 * This keeps track of all the supported types checked by {@link #isFactoryForType isFactoryForType}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected Collection<Object> supportedTypes = new ArrayList<Object>();

	/**
	 * This constructs an instance.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public StandardItemProviderAdapterFactory() {
		supportedTypes.add(IEditingDomainItemProvider.class);
		supportedTypes.add(IStructuredItemContentProvider.class);
		supportedTypes.add(ITreeItemContentProvider.class);
		supportedTypes.add(IItemLabelProvider.class);
		supportedTypes.add(IItemPropertySource.class);
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Auxiliary} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected AuxiliaryItemProvider auxiliaryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Auxiliary}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createAuxiliaryAdapter() {
		if(auxiliaryItemProvider == null) {
			auxiliaryItemProvider = new AuxiliaryItemProvider(this);
		}

		return auxiliaryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.BuildComponent} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected BuildComponentItemProvider buildComponentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.BuildComponent}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createBuildComponentAdapter() {
		if(buildComponentItemProvider == null) {
			buildComponentItemProvider = new BuildComponentItemProvider(this);
		}

		return buildComponentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Create} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected CreateItemProvider createItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Create}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createCreateAdapter() {
		if(createItemProvider == null) {
			createItemProvider = new CreateItemProvider(this);
		}

		return createItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Call} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected CallItemProvider callItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Call}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createCallAdapter() {
		if(callItemProvider == null) {
			callItemProvider = new CallItemProvider(this);
		}

		return callItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Derive} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected DeriveItemProvider deriveItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Derive}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createDeriveAdapter() {
		if(deriveItemProvider == null) {
			deriveItemProvider = new DeriveItemProvider(this);
		}

		return deriveItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Destroy} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected DestroyItemProvider destroyItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Destroy}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createDestroyAdapter() {
		if(destroyItemProvider == null) {
			destroyItemProvider = new DestroyItemProvider(this);
		}

		return destroyItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Focus} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected FocusItemProvider focusItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Focus}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createFocusAdapter() {
		if(focusItemProvider == null) {
			focusItemProvider = new FocusItemProvider(this);
		}

		return focusItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Framework} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected FrameworkItemProvider frameworkItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Framework}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createFrameworkAdapter() {
		if(frameworkItemProvider == null) {
			frameworkItemProvider = new FrameworkItemProvider(this);
		}

		return frameworkItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Implement} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected ImplementItemProvider implementItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Implement}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createImplementAdapter() {
		if(implementItemProvider == null) {
			implementItemProvider = new ImplementItemProvider(this);
		}

		return implementItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.ImplementationClass} instances.
	 * <!-- begin-user-doc
	 * --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ImplementationClassItemProvider implementationClassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.ImplementationClass}.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createImplementationClassAdapter() {
		if(implementationClassItemProvider == null) {
			implementationClassItemProvider = new ImplementationClassItemProvider(this);
		}

		return implementationClassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Instantiate} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected InstantiateItemProvider instantiateItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Instantiate}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createInstantiateAdapter() {
		if(instantiateItemProvider == null) {
			instantiateItemProvider = new InstantiateItemProvider(this);
		}

		return instantiateItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Metaclass} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected MetaclassItemProvider metaclassItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Metaclass}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createMetaclassAdapter() {
		if(metaclassItemProvider == null) {
			metaclassItemProvider = new MetaclassItemProvider(this);
		}

		return metaclassItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.ModelLibrary} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected ModelLibraryItemProvider modelLibraryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.ModelLibrary}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createModelLibraryAdapter() {
		if(modelLibraryItemProvider == null) {
			modelLibraryItemProvider = new ModelLibraryItemProvider(this);
		}

		return modelLibraryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Refine} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected RefineItemProvider refineItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Refine}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createRefineAdapter() {
		if(refineItemProvider == null) {
			refineItemProvider = new RefineItemProvider(this);
		}

		return refineItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Responsibility} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected ResponsibilityItemProvider responsibilityItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Responsibility}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createResponsibilityAdapter() {
		if(responsibilityItemProvider == null) {
			responsibilityItemProvider = new ResponsibilityItemProvider(this);
		}

		return responsibilityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Script} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected ScriptItemProvider scriptItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Script}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createScriptAdapter() {
		if(scriptItemProvider == null) {
			scriptItemProvider = new ScriptItemProvider(this);
		}

		return scriptItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Send} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected SendItemProvider sendItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Send}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createSendAdapter() {
		if(sendItemProvider == null) {
			sendItemProvider = new SendItemProvider(this);
		}

		return sendItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Trace} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected TraceItemProvider traceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Trace}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createTraceAdapter() {
		if(traceItemProvider == null) {
			traceItemProvider = new TraceItemProvider(this);
		}

		return traceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Type} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected TypeItemProvider typeItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Type}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createTypeAdapter() {
		if(typeItemProvider == null) {
			typeItemProvider = new TypeItemProvider(this);
		}

		return typeItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Utility} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected UtilityItemProvider utilityItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Utility}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createUtilityAdapter() {
		if(utilityItemProvider == null) {
			utilityItemProvider = new UtilityItemProvider(this);
		}

		return utilityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Document} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected DocumentItemProvider documentItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Document}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createDocumentAdapter() {
		if(documentItemProvider == null) {
			documentItemProvider = new DocumentItemProvider(this);
		}

		return documentItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Entity} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected EntityItemProvider entityItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Entity}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createEntityAdapter() {
		if(entityItemProvider == null) {
			entityItemProvider = new EntityItemProvider(this);
		}

		return entityItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Executable} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected ExecutableItemProvider executableItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Executable}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createExecutableAdapter() {
		if(executableItemProvider == null) {
			executableItemProvider = new ExecutableItemProvider(this);
		}

		return executableItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.File} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected FileItemProvider fileItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.File}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createFileAdapter() {
		if(fileItemProvider == null) {
			fileItemProvider = new FileItemProvider(this);
		}

		return fileItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Library} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected LibraryItemProvider libraryItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Library}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createLibraryAdapter() {
		if(libraryItemProvider == null) {
			libraryItemProvider = new LibraryItemProvider(this);
		}

		return libraryItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Process} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected ProcessItemProvider processItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Process}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createProcessAdapter() {
		if(processItemProvider == null) {
			processItemProvider = new ProcessItemProvider(this);
		}

		return processItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Realization} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected RealizationItemProvider realizationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Realization}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createRealizationAdapter() {
		if(realizationItemProvider == null) {
			realizationItemProvider = new RealizationItemProvider(this);
		}

		return realizationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Service} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected ServiceItemProvider serviceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Service}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createServiceAdapter() {
		if(serviceItemProvider == null) {
			serviceItemProvider = new ServiceItemProvider(this);
		}

		return serviceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Source} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected SourceItemProvider sourceItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Source}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createSourceAdapter() {
		if(sourceItemProvider == null) {
			sourceItemProvider = new SourceItemProvider(this);
		}

		return sourceItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Specification} instances.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	protected SpecificationItemProvider specificationItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Specification}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createSpecificationAdapter() {
		if(specificationItemProvider == null) {
			specificationItemProvider = new SpecificationItemProvider(this);
		}

		return specificationItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Subsystem} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected SubsystemItemProvider subsystemItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Subsystem}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createSubsystemAdapter() {
		if(subsystemItemProvider == null) {
			subsystemItemProvider = new SubsystemItemProvider(this);
		}

		return subsystemItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.Metamodel} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected MetamodelItemProvider metamodelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.Metamodel}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createMetamodelAdapter() {
		if(metamodelItemProvider == null) {
			metamodelItemProvider = new MetamodelItemProvider(this);
		}

		return metamodelItemProvider;
	}

	/**
	 * This keeps track of the one adapter used for all {@link org.eclipse.papyrus.uml.standard.SystemModel} instances.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	protected SystemModelItemProvider systemModelItemProvider;

	/**
	 * This creates an adapter for a {@link org.eclipse.papyrus.uml.standard.SystemModel}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter createSystemModelAdapter() {
		if(systemModelItemProvider == null) {
			systemModelItemProvider = new SystemModelItemProvider(this);
		}

		return systemModelItemProvider;
	}

	/**
	 * This returns the root adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public ComposeableAdapterFactory getRootAdapterFactory() {
		return parentAdapterFactory == null ? this : parentAdapterFactory.getRootAdapterFactory();
	}

	/**
	 * This sets the composed adapter factory that contains this factory.
	 * <!-- begin-user-doc -->
	 * <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void setParentAdapterFactory(ComposedAdapterFactory parentAdapterFactory) {
		this.parentAdapterFactory = parentAdapterFactory;
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public boolean isFactoryForType(Object type) {
		return supportedTypes.contains(type) || super.isFactoryForType(type);
	}

	/**
	 * This implementation substitutes the factory itself as the key for the adapter. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Adapter adapt(Notifier notifier, Object type) {
		return super.adapt(notifier, this);
	}

	/**
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	@Override
	public Object adapt(Object object, Object type) {
		if(isFactoryForType(type)) {
			Object adapter = super.adapt(object, type);
			if(!(type instanceof Class<?>) || (((Class<?>)type).isInstance(adapter))) {
				return adapter;
			}
		}

		return null;
	}

	/**
	 * This adds a listener.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void addListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.addListener(notifyChangedListener);
	}

	/**
	 * This removes a listener.
	 * <!-- begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void removeListener(INotifyChangedListener notifyChangedListener) {
		changeNotifier.removeListener(notifyChangedListener);
	}

	/**
	 * This delegates to {@link #changeNotifier} and to {@link #parentAdapterFactory}. <!--
	 * begin-user-doc --> <!-- end-user-doc -->
	 * 
	 * @generated
	 */
	public void fireNotifyChanged(Notification notification) {
		changeNotifier.fireNotifyChanged(notification);

		if(parentAdapterFactory != null) {
			parentAdapterFactory.fireNotifyChanged(notification);
		}
	}

	/**
	 * This disposes all of the item providers created by this factory.
	 * <!-- begin-user-doc --> <!--
	 * end-user-doc -->
	 * 
	 * @generated
	 */
	public void dispose() {
		if(auxiliaryItemProvider != null)
			auxiliaryItemProvider.dispose();
		if(buildComponentItemProvider != null)
			buildComponentItemProvider.dispose();
		if(createItemProvider != null)
			createItemProvider.dispose();
		if(callItemProvider != null)
			callItemProvider.dispose();
		if(deriveItemProvider != null)
			deriveItemProvider.dispose();
		if(destroyItemProvider != null)
			destroyItemProvider.dispose();
		if(focusItemProvider != null)
			focusItemProvider.dispose();
		if(frameworkItemProvider != null)
			frameworkItemProvider.dispose();
		if(implementItemProvider != null)
			implementItemProvider.dispose();
		if(implementationClassItemProvider != null)
			implementationClassItemProvider.dispose();
		if(instantiateItemProvider != null)
			instantiateItemProvider.dispose();
		if(metaclassItemProvider != null)
			metaclassItemProvider.dispose();
		if(modelLibraryItemProvider != null)
			modelLibraryItemProvider.dispose();
		if(refineItemProvider != null)
			refineItemProvider.dispose();
		if(responsibilityItemProvider != null)
			responsibilityItemProvider.dispose();
		if(scriptItemProvider != null)
			scriptItemProvider.dispose();
		if(sendItemProvider != null)
			sendItemProvider.dispose();
		if(traceItemProvider != null)
			traceItemProvider.dispose();
		if(typeItemProvider != null)
			typeItemProvider.dispose();
		if(utilityItemProvider != null)
			utilityItemProvider.dispose();
		if(documentItemProvider != null)
			documentItemProvider.dispose();
		if(entityItemProvider != null)
			entityItemProvider.dispose();
		if(executableItemProvider != null)
			executableItemProvider.dispose();
		if(fileItemProvider != null)
			fileItemProvider.dispose();
		if(libraryItemProvider != null)
			libraryItemProvider.dispose();
		if(processItemProvider != null)
			processItemProvider.dispose();
		if(realizationItemProvider != null)
			realizationItemProvider.dispose();
		if(serviceItemProvider != null)
			serviceItemProvider.dispose();
		if(sourceItemProvider != null)
			sourceItemProvider.dispose();
		if(specificationItemProvider != null)
			specificationItemProvider.dispose();
		if(subsystemItemProvider != null)
			subsystemItemProvider.dispose();
		if(metamodelItemProvider != null)
			metamodelItemProvider.dispose();
		if(systemModelItemProvider != null)
			systemModelItemProvider.dispose();
	}

}
