/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.umlutils;

import java.util.Iterator;
import org.eclipse.papyrus.umlutils.NamedElementUtil;
import org.eclipse.uml2.uml.Classifier;
import org.eclipse.uml2.uml.InstanceSpecification;
import org.eclipse.uml2.uml.NamedElement;

public class InstanceSpecificationUtil {
    public static String getCustomLabel(InstanceSpecification instance, int style) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(" ");
        if ((style & 8) != 0) {
            buffer.append(NamedElementUtil.getName((NamedElement)instance));
        }
        if ((style & 0x10) != 0 && !InstanceSpecificationUtil.getTypesAsString(instance, style).equals("")) {
            buffer.append(": ");
            buffer.append(InstanceSpecificationUtil.getTypesAsString(instance, style));
        }
        return buffer.toString();
    }

    private static String getTypesAsString(InstanceSpecification instance, int style) {
        StringBuffer typeString = new StringBuffer();
        Iterator classifierIterator = instance.getClassifiers().iterator();
        boolean firstParameter = true;
        while (classifierIterator.hasNext()) {
            Classifier classifier = (Classifier)classifierIterator.next();
            String classifierName = NamedElementUtil.getName((NamedElement)classifier);
            if (classifierName.trim().equals("")) continue;
            if (!firstParameter) {
                typeString.append(", ");
            }
            typeString.append(classifierName);
            firstParameter = false;
        }
        return typeString.toString();
    }
}

